<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!--Testimonial One Start-->
    <section class="testimonial-one">
        <div class="testimonial-one__inner">
            <div class="testimonial-one__bg" style="background-image: url(<?php echo esc_url($settings['background_shape']['url']); ?>);"></div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-4">
                        <div class="testimonial-one__left">
                            <div class="section-title text-left">
                                <?php
                                if (!empty($settings['sec_sub_title'])) :
                                    $this->add_inline_editing_attributes('sec_sub_title', 'none');
                                    apsro_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
                                endif;

                                if (!empty($settings['sec_title'])) :
                                    $this->add_inline_editing_attributes('sec_title', 'none');
                                    apsro_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
                                endif;
                                ?>
                            </div>
                            <?php
                            if (!empty($settings['sec_summary'])) :
                                $this->add_inline_editing_attributes('sec_summary', 'none');
                                apsro_elementor_rendered_content($this, 'sec_summary', 'testimonial-one__left-text', 'p');
                            endif;
                            ?>
                            <div class="testimonial-one__ratting-box">
                                <div class="testimonial-one__ratting">
                                    <?php for ($i = 0; $i < $settings['rating']['size']; $i++) : ?>
                                        <span class="fas fa-star"></span>
                                    <?php endfor; ?>
                                </div>
                                <?php
                                if (!empty($settings['rating_title'])) :
                                    $this->add_inline_editing_attributes('rating_title', 'none');
                                    apsro_elementor_rendered_content($this, 'rating_title', '', 'p');
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-8">
                        <div class="testimonial-one__right">
                            <div class="testimonial-one__img-1">
                                <?php apsro_elementor_rendered_image($settings, 'image_one'); ?>
                                <div class="testimonial-one__img-2">
                                    <?php apsro_elementor_rendered_image($settings, 'image_two'); ?>
                                </div>
                            </div>
                            <div class="testimonial-one__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(apsro_get_owl_options($settings)); ?>'>
                                <?php foreach ($settings['testimonials'] as $index => $item) :  ?>
                                    <!--Testimonial One Single Start-->
                                    <div class="item">
                                        <div class="testimonial-one__single">
                                            <div class="testimonial-one__client-info-and-quote">
                                                <div class="testimonial-one__client-info">
                                                    <?php
                                                    if (!empty($item['name'])) :
                                                        apsro_basic_rendered_content($this, $item,  'name', '', $item['testimonial_title_tag_layout_one']);
                                                    endif;

                                                    if (!empty($item['designation'])) :
                                                        apsro_basic_rendered_content($this, $item,  'designation', '', 'p');
                                                    endif;
                                                    ?>
                                                </div>
                                                <div class="testimonial-one__quote">
                                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                                </div>
                                            </div>
                                            <?php
                                            if (!empty($item['testimonial'])) :
                                                apsro_basic_rendered_content($this, $item,  'testimonial', 'testimonial-one__text', 'p');
                                            endif;
                                            ?>
                                        </div>
                                    </div>
                                    <!--Testimonial One Single End-->
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Testimonial One End-->

<?php endif; ?>