<?php if ('layout_three' === $settings['layout_type']) : ?>

    <!--Testimonial Three Start-->
    <section class="testimonial-three">
        <div class="testimonial-three__bg jarallax" data-jarallax data-speed="0.2" data-imgPosition="50% 0%" style="background-image: url(<?php echo esc_url($settings['layout_three_bg_image']['url']); ?>);"></div>
        <div class="container">
            <div class="testimonial-three__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(apsro_get_owl_options($settings)); ?>'>
                <?php foreach ($settings['layout_three_testimonials'] as $index => $item) :  ?>
                    <!--Testimonial one Single Start-->
                    <div class="item">
                        <div class="testimonial-three__single">
                            <div class="testimonial-three__img">
                                <?php apsro_elementor_rendered_image($item, 'image'); ?>
                                <div class="testimonial-three__quote">
                                    <?php apsro_elementor_rendered_image($item, 'quotation_image'); ?>
                                </div>
                            </div>
                            <div class="testimonial-three__content">
                                <?php
                                if (!empty($item['testimonial'])) :
                                    apsro_basic_rendered_content($this, $item,  'testimonial', 'testimonial-three__text', 'p');
                                endif;
                                ?>
                                <div class="testimonial-three__client-name">
                                    <h4><?php echo esc_html($item['name']); ?><span><?php echo esc_html($item['designation']); ?></span></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Testimonial one Single End-->
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!--Testimonial Three End-->
<?php endif; ?>