<?php

namespace Layerdrops\Apsro;

class Assets
{

    /**
     * Class constructor
     */
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_assets']);
        add_action('admin_enqueue_scripts', [$this, 'register_assets']);
    }

    /**
     * All available scripts
     *
     * @return array
     */
    public function get_scripts()
    {
        return [
            'bootstrap-select' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/bootstrap-select/js/bootstrap-select.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/bootstrap-select/js/bootstrap-select.min.js'),
                'deps'    => ['jquery', 'bootstrap']
            ],
            'jquery-bxslider' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.min.js'),
                'deps'    => ['jquery']
            ],
            'countdown' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/countdown/countdown.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/countdown/countdown.min.js'),
                'deps'    => ['jquery']
            ],
            'jarallax' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jarallax/jarallax.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jarallax/jarallax.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-ajaxchimp' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-appear' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jquery-appear/jquery.appear.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jquery-appear/jquery.appear.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-circle-progress' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jquery-circle-progress/jquery.circle-progress.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-magnific-popup' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js'),
                'deps'    => ['jquery']
            ],
            'odometer' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/odometer/odometer.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/odometer/odometer.min.js'),
                'deps'    => ['jquery']
            ],
            'owl-carousel' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.js'),
                'deps'    => ['jquery']
            ],
            'swiper' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/swiper/swiper.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/swiper/swiper.min.js'),
                'deps'    => ['jquery']
            ],
            'wow' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/wow/wow.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/wow/wow.js'),
                'deps'    => ['jquery']
            ],

            'sharer' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/sharer/sharer.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/sharer/sharer.min.js'),
                'deps'    => ['jquery']
            ],

            'circletype' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/circleType/jquery.circleType.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/circleType/jquery.circleType.js'),
                'deps'    => ['jquery']
            ],

            'circleletter' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/circleType/jquery.lettering.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/circleType/jquery.lettering.min.js'),
                'deps'    => ['jquery']
            ],
            'select2' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/select2/js/select2.min.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/select2/js/select2.min.js'),
                'deps'    => ['jquery']
            ],
            'timepicker' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/timepicker/timePicker.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/timepicker/timePicker.js'),
                'deps'    => ['jquery']
            ],
            'apsro-addon-customizer' => [
                'src'     => APSRO_ADDON_ASSETS . '/js/apsro-addon-customizer.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/js/apsro-addon-customizer.js'),
                'deps'    => ['jquery', 'select2']
            ],
            'apsro-addon-script' => [
                'src'     => APSRO_ADDON_ASSETS . '/js/apsro-addon.js',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/js/apsro-addon.js'),
                'deps'    => ['jquery']
            ]
        ];
    }

    /**
     * All available styles
     *
     * @return array
     */
    public function get_styles()
    {
        return [
            'animate' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/animate/animate.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/animate/animate.min.css')
            ],
            'custom-animate' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/animate/custom-animate.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/animate/custom-animate.css')
            ],
            'bootstrap-select' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/bootstrap-select/css/bootstrap-select.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/bootstrap-select/css/bootstrap-select.min.css')
            ],
            'bxslider' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.css')
            ],
            'jarallax' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jarallax/jarallax.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jarallax/jarallax.css')
            ],
            'jquery-magnific-popup' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')
            ],
            'odometer' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/odometer/odometer.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/odometer/odometer.min.css')
            ],
            'owl-carousel' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.css')
            ],
            'owl-theme' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/owl-carousel/owl.theme.default.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/owl-carousel/owl.theme.default.min.css')
            ],
            'reey-font' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/reey-font/stylesheet.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/reey-font/stylesheet.css')
            ],
            'alagambe-font' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/alagambe-font/stylesheet.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/alagambe-font/stylesheet.css')
            ],
            'swiper' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/swiper/swiper.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/swiper/swiper.min.css')
            ],
            'select2' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/select2/css/select2.min.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/select2/css/select2.min.css')
            ],
            'jquery-ui' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/jquery-ui/jquery-ui.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/jquery-ui/jquery-ui.css')
            ],
            'timepicker' => [
                'src'     => APSRO_ADDON_ASSETS . '/vendors/timepicker/timePicker.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/vendors/timepicker/timePicker.css')
            ],
            'apsro-addon-style' => [
                'src'     => APSRO_ADDON_ASSETS . '/css/apsro-addon.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/css/apsro-addon.css')
            ],
            'apsro-addon-admin-style' => [
                'src'     => APSRO_ADDON_ASSETS . '/css/apsro-addon-admin.css',
                'version' => filemtime(APSRO_ADDON_PATH . '/assets/css/apsro-addon-admin.css')
            ]
        ];
    }

    /**
     * Register scripts and styles
     *
     * @return void
     */
    public function register_assets()
    {
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;

            wp_register_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;

            wp_register_style($handle, $style['src'], $deps, $style['version']);
        }
    }
}
