<?php

namespace Layerdrops\Apsro;

class Customizer
{
    public function __construct()
    {
        add_action("customize_register", [$this, 'apsro_customizer']);
    }
    public function apsro_customizer($wp_customize)
    {

        // add panel
        $wp_customize->add_panel(
            'apsro_theme_opt',
            array(
                'title'      => esc_html__('Apsro Options', 'apsro-addon'),
                'description' => esc_html__('Apsro Theme options panel', 'apsro-addon'),
                'priority'   => 220,
                'capability' => 'edit_theme_options',
            )
        );

        // General Settings
        $wp_customize->add_section('apsro_theme_general', array(
            'title' => __('General Settings', 'apsro-addon'),
            'description' => esc_html__('Apsro General Settings.', 'apsro-addon'),
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));


        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Base color', 'apsro-addon'),
            'apsro_theme_general',
            'theme_base_color',
            '#df2818'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Primary color', 'apsro-addon'),
            'apsro_theme_general',
            'theme_primary_color',
            '#f6f6f6'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Black color', 'apsro-addon'),
            'apsro_theme_general',
            'theme_black_color',
            '#000000'
        );


        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Dark Mode?', 'apsro-addon'),
            'apsro_theme_general',
            'apsro_dark_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Boxed Mode?', 'apsro-addon'),
            'apsro_theme_general',
            'apsro_boxed_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Rtl Mode?', 'apsro-addon'),
            'apsro_theme_general',
            'apsro_rtl_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Custom Cursor', 'apsro-addon'),
            'apsro_theme_general',
            'custom_cursor',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Back to top?', 'apsro-addon'),
            'apsro_theme_general',
            'scroll_to_top',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Back to top icon', 'apsro-addon'),
            'apsro_theme_general',
            'scroll_to_top_icon',
            'fa-angle-up',
            apsro_get_fa_icons(),
            function () {
                return (get_theme_mod('scroll_to_top', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Preloader?', 'apsro-addon'),
            'apsro_theme_general',
            'preloader',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Custom Preloader Image', 'apsro-addon'),
            'apsro_theme_general',
            'preloader_image',
            '',
            function () {
                return (get_theme_mod('preloader', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Page Header Background Image', 'apsro-addon'),
            'apsro_theme_general',
            'page_header_bg_image'
        );

        // Blog Layout
        $wp_customize->add_section('apsro_blog_layout_settings', array(
            'title' => __('Blog Layout', 'apsro-addon'),
            'description' => esc_html__('Apsro Blog Layout', 'apsro-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));

        $this->customize_type_select(
            $wp_customize,
            'Select Sidebar position',
            'apsro_blog_layout_settings',
            'apsro_blog_layout',
            'right-align',
            array(
                'left-align' => esc_html__('Left Align', 'apsro-addon'),
                'right-align' => esc_html__('Right Align', 'apsro-addon'),
            )
        );

        // Header options
        $wp_customize->add_section('apsro_theme_header', array(
            'title' => __('Header Settings', 'apsro-addon'),
            'description' => esc_html__('Apsro Header Settings', 'apsro-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Add Logo size in px', 'apsro-addon'),
            'apsro_theme_header',
            'header_logo_width',
            esc_html(198)
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Sticky Header?', 'apsro-addon'),
            'apsro_theme_header',
            'header_sticky_menu',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Breadcrumb?', 'apsro-addon'),
            'apsro_theme_header',
            'breadcrumb_opt',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Header?', 'apsro-addon'),
            'apsro_theme_header',
            'header_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Header Type', 'apsro-addon'),
            'apsro_theme_header',
            'header_custom_post',
            '',
            apsro_post_query('header'),
            function () {
                return (get_theme_mod('header_custom', 'no') == 'yes' ? true : false);
            }
        );

        //  Mobile Menu
        $wp_customize->add_section('apsro_theme_mobile_menu', array(
            'title' => esc_html__('Mobile Menu Settings', 'apsro-addon'),
            'description' => esc_html__('Apsro Header Settings', 'apsro-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Email', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'apsro_mobile_menu_email',
            esc_html__('needhelp@apsro.com', 'apsro-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Phone', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'apsro_mobile_menu_phone',
            esc_html__('666 888 0000', 'apsro-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Facebook url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'facebook_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Twitter url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'twitter_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Linkedin url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'linkedin_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Pinterest url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'pinterest_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Youtube url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'youtube_url',
        );


        $this->customize_type_text(
            $wp_customize,
            esc_html__('dribbble url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'dribble_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Instagram url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'instagram_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Reddit url', 'apsro-addon'),
            'apsro_theme_mobile_menu',
            'reddit_url',
        );

        // Footer options
        $wp_customize->add_section('apsro_theme_footer', array(
            'title' => esc_html__('Footer Settings', 'apsro-addon'),
            'description' => esc_html__('Apsro Footer Settings.', 'apsro-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Footer Text', 'apsro-addon'),
            'apsro_theme_footer',
            'footer_copytext',
            esc_html__('&copy; All right reserved', 'apsro'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? false : true);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Footer ?', 'apsro-addon'),
            'apsro_theme_footer',
            'footer_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Footer Type', 'apsro-addon'),
            'apsro_theme_footer',
            'footer_custom_post',
            '',
            apsro_post_query('footer'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? true : false);
            }
        );

        // register
        $wp_customize->add_section('apsro_login_settings', array(
            'title' => __('Login/Register Settings', 'apsro-addon'),
            'description' => esc_html__('Login/Register Settings', 'apsro-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Login', 'apsro-addon'),
            'apsro_login_settings',
            'login_redirect_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Registration', 'apsro-addon'),
            'apsro_login_settings',
            'registration_redirect_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Log Out', 'apsro-addon'),
            'apsro_login_settings',
            'logout_redirect_url',
        );

        // error page
        $wp_customize->add_section('apsro_error_page_settings', array(
            'title' => __('404 Settings', 'apsro-addon'),
            'description' => esc_html__('Change 404 Text', 'apsro-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'apsro_theme_opt'
        ));

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom 404 ?', 'apsro-addon'),
            'apsro_error_page_settings',
            'error_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'apsro-addon'),
                'no' => esc_html__('No', 'apsro-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select 404 Page', 'apsro-addon'),
            'apsro_error_page_settings',
            'error_custom_post',
            '',
            apsro_post_query('page'),
            function () {
                return (get_theme_mod('error_custom', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('404 Page Title Image', 'apsro-addon'),
            'apsro_error_page_settings',
            '404_page_title_image'
        );
    }

    //type text
    public function customize_type_text($wp_customize, $label, $section_id, $name,  $default = "", $callback = null)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => $default,
            'type'     => 'theme_mod'
        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "text",
                "active_callback" => $callback,
            )
        ));
    }


    //type color
    public function customize_type_color($wp_customize, $label, $section_id, $name,  $default)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => sanitize_hex_color($default),
            'type'     => 'theme_mod'
        ));

        // Add control
        $wp_customize->add_control(new \WP_Customize_Color_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 1
        )));
    }

    // type checkbox
    public function customize_type_checkbox($wp_customize, $label, $section_id, $name,  $default, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "checkbox",
                "active_callback" => $callback,
            )
        ));
    }

    // type Image
    public function customize_type_image($wp_customize, $label, $section_id, $name,  $default = '', $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Upload_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 20,
            "active_callback" => $callback,
        )));
    }

    public function customize_type_select($wp_customize, $label, $section_id, $name,  $default, $select_value,  $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "select",
                'choices'     => $select_value,
                "active_callback" => $callback,
            )
        ));
    }

    public function customize_type_radio($wp_customize, $label, $section_id, $name,  $default, $radio_value, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "radio",
                'choices'     => $radio_value,
                "active_callback" => $callback,
            )
        ));
    }
}
