<?php

namespace Layerdrops\Apsro\Metaboxes;


class Page
{
    function __construct()
    {
        add_action('cmb2_admin_init', [$this, 'page_metabox']);
    }

    function page_metabox()
    {
        $prefix = 'apsro_';

        $general = new_cmb2_box(array(
            'id'           => $prefix . 'page_option',
            'title'        => __('General Options', 'apsro-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Header', 'apsro-addon'),
            'id' => $prefix . 'custom_header_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'apsro-addon'),
                'off'   => __('Off', 'apsro-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Header', 'apsro-addon'),
            'id' => $prefix . 'select_custom_header',
            'type' => 'pw_select',
            'options' => apsro_post_query('header'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_header_status',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Footer', 'apsro-addon'),
            'id' => $prefix . 'custom_footer_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'apsro-addon'),
                'off'   => __('Off', 'apsro-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Footer', 'apsro-addon'),
            'id' => $prefix . 'select_custom_footer',
            'type' => 'pw_select',
            'options' => apsro_post_query('footer'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_footer_status',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Show Page Banner', 'apsro-addon'),
            'id' => $prefix . 'show_page_banner',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'apsro-addon'),
                'off' => __('Off', 'apsro-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable BreadCrumb', 'apsro-addon'),
            'id' => $prefix . 'show_page_breadcrumb',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'apsro-addon'),
                'off' => __('Off', 'apsro-addon'),
            ),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Header Title', 'apsro-addon'),
            'id' => $prefix . 'set_header_title',
            'type' => 'text',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Header Image', 'apsro-addon'),
            'id' => $prefix . 'set_header_image',
            'type' => 'file',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $color_options = new_cmb2_box(array(
            'id'           => $prefix . 'page_color_option',
            'title'        => __('Color Options', 'apsro-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));


        $general->add_field(array(
            'name' => __('Enable RTL Mode', 'apsro-addon'),
            'id' => $prefix . 'enable_rtl_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'apsro-addon'),
                'no' => __('Off', 'apsro-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Boxed Layout', 'apsro-addon'),
            'id' => $prefix . 'enable_boxed_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'apsro-addon'),
                'no' => __('Off', 'apsro-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Dark Mode', 'apsro-addon'),
            'id'   => $prefix . 'enable_dark_mode',
            'type' => 'checkbox',
        ));


        $color_options->add_field(array(
            'name' => __('Base Color', 'apsro-addon'),
            'id' => $prefix . 'base_color',
            'type'    => 'colorpicker',
        ));

        $color_options->add_field(array(
            'name' => __('Primary Color', 'apsro-addon'),
            'id' => $prefix . 'primary_color',
            'type'    => 'colorpicker',
        ));

        $color_options->add_field(array(
            'name' => __('Secondary Color', 'apsro-addon'),
            'id' => $prefix . 'secondary_color',
            'type'    => 'colorpicker',
        ));
    }
}
