<?php

namespace Layerdrops\Apsro\Widgets;


class About extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'apsro-about';
	}

	public function get_title()
	{
		return __('About', 'apsro-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['apsro-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'apsro-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'apsro-addon'),
					'layout_two' => __('Layout Two', 'apsro-addon'),
					'layout_three' => __('Layout Three', 'apsro-addon'),
					// 'layout_four' => __('Layout Four', 'apsro-addon'),
				]
			]
		);

		$this->end_controls_section();

		include apsro_get_elementor_option('about-one-option.php');
		include apsro_get_elementor_option('about-two-option.php');
		include apsro_get_elementor_option('about-three-option.php');
		// include apsro_get_elementor_option('about-four-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);

		apsro_elementor_general_style_options($this, 'Summary Text', '{{WRAPPER}} .about-one__text-2,{{WRAPPER}} .about-two__text,{{WRAPPER}} .about-three__text', ['layout_one', 'layout_two', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Highlighted Text', '{{WRAPPER}} .about-one__text-1', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Client Name', '{{WRAPPER}} .about-one__user-content h4', ['layout_one']);
		apsro_elementor_general_style_options($this, 'Client Designation', '{{WRAPPER}} .about-one__user-content p', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Check List Title', '{{WRAPPER}} .about-one__points-title h3,{{WRAPPER}} .about-two__points li .text p', ['layout_one', 'layout_two']);
		apsro_elementor_general_style_options($this, 'Check List Sub Title', '{{WRAPPER}} .about-one__points-text', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Progress Title', '{{WRAPPER}} .about-one__progress-title,{{WRAPPER}} .about-three__progress-title', ['layout_one', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Progress Number', '{{WRAPPER}} .about-one__progress .count-text', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Feature Title', '{{WRAPPER}} .about-two__icon-box h3,{{WRAPPER}} .about-three__points li .text p', ['layout_two', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Feature Sub Title', '{{WRAPPER}} .about-two__icon-box-and-text p', ['layout_two']);

		$this->end_controls_section();

		//button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one', 'layout_two', 'layout_three']
				]
			]
		);

		apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_one', 'layout_two', 'layout_three']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include apsro_get_template('about-one.php');
		include apsro_get_template('about-two.php');
		include apsro_get_template('about-three.php');
		// include apsro_get_template('about-four.php');
	}
}
