<?php

namespace Layerdrops\Apsro\Widgets;


class Award extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'apsro-award';
	}

	public function get_title()
	{
		return __('Award', 'apsro-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['apsro-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'apsro-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'apsro-addon'),
					'layout_two' => __('Layout Two', 'apsro-addon'),
				]
			]
		);

		$this->end_controls_section();

		include apsro_get_elementor_option('award-one-option.php');
		include apsro_get_elementor_option('award-two-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_two']);
		apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_two']);

		apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .awards-one__title,{{WRAPPER}} .awards-two__text', ['layout_one', 'layout_two']);
		apsro_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .award-one__text,{{WRAPPER}} .award-one__sub-title,{{WRAPPER}} .award-one__text-2,{{WRAPPER}} .awards-one__text', ['layout_one']);
		apsro_elementor_general_style_options($this, 'Number', '{{WRAPPER}} .awards-two__name p', ['layout_two']);
		apsro_elementor_general_style_options($this, 'Year', '{{WRAPPER}} .awards-two__year span', ['layout_two']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include apsro_get_template('award-one.php');
		include apsro_get_template('award-two.php');
	}
}
