<?php

namespace Layerdrops\Apsro\Widgets;


class Blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-blog';
    }

    public function get_title()
    {
        return __('Blog', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    // 'layout_three' => __('Layout Three', 'apsro-addon'),
                    // 'layout_four' => __('Layout Four', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  apsro_get_elementor_option('blog-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);

        apsro_elementor_general_style_options($this, 'Post Title', '{{WRAPPER}} .blog-one__title>a,{{WRAPPER}} .blog-two__title a', ['layout_one', 'layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Post Meta', '{{WRAPPER}} .blog-one__meta li p,{{WRAPPER}} .blog-one__meta li a', ['layout_one', 'layout_two']);

        apsro_elementor_general_style_options($this, 'Post Date', '{{WRAPPER}} .blog-one__date p,{{WRAPPER}} .blog-two__date p', ['layout_one', 'layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Read More', '{{WRAPPER}} .blog-one__btn-box a,{{WRAPPER}} .blog-two__comment a', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();

        apsro_elementor_column_count_options($this, ['layout_one', 'layout_two', 'layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('blog-one.php');
        include apsro_get_template('blog-two.php');
        // include apsro_get_template('blog-three.php');
        // include apsro_get_template('blog-four.php');
    }
}
