<?php

namespace Layerdrops\Apsro\Widgets;


class CallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-call-to-action';
    }

    public function get_title()
    {
        return __('Call To Action', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    // 'layout_three' => __('Layout Three', 'apsro-addon'),
                ]
            ]
        );
        $this->end_controls_section();

        include apsro_get_elementor_option('call-to-action-one-option.php');
        include apsro_get_elementor_option('call-to-action-two-option.php');
        // include apsro_get_elementor_option('call-to-action-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .cta-one__title,{{WRAPPER}} .cta-two__title-box h3', ['layout_one', 'layout_two']);
        apsro_elementor_general_style_options($this, 'Highlighted Title', '{{WRAPPER}} .cta-two__title-box h3 span', ['layout_two']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );

        apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .cta-one__arrow a,{{WRAPPER}} .cta-two__btn a', '{{WRAPPER}} .cta-one__arrow a:hover,{{WRAPPER}} .cta-two__btn a:hover', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('call-to-action-one.php');
        include apsro_get_template('call-to-action-two.php');
        // include apsro_get_template('call-to-action-three.php');
    }
}
