<?php

namespace Layerdrops\Apsro\Widgets;


class Choose extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'apsro-choose';
	}

	public function get_title()
	{
		return __('Choose Us', 'apsro-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['apsro-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'apsro-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'apsro-addon'),
					'layout_two' => __('Layout Two', 'apsro-addon'),
					'layout_three' => __('Layout Three', 'apsro-addon'),
				]
			]
		);

		$this->end_controls_section();

		include apsro_get_elementor_option('choose-one-option.php');
		include apsro_get_elementor_option('choose-two-option.php');
		include apsro_get_elementor_option('choose-three-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .why-choose-one__text,{{WRAPPER}} .why-choose-three__text', ['layout_one', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Section Highlighted Text', '{{WRAPPER}} .why-choose-one__text-2', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .why-choose-one__points li .text p,{{WRAPPER}} .tabs-one__inner .tab-buttons .tab-btn span,{{WRAPPER}} .why-choose-three__points li .text p', ['layout_one', 'layout_two', 'layout_three']);
		apsro_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .why-choose-one__points li .text p,{{WRAPPER}} .tabs-one__text', ['layout_one', 'layout_two']);
		apsro_elementor_general_style_options($this, 'Check List', '{{WRAPPER}} .why-choose-one__points li .text p,{{WRAPPER}} .tabs-one__points li .text p', ['layout_one', 'layout_two']);

		$this->end_controls_section();

		//button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_three']
				]
			]
		);

		apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_three']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include apsro_get_template('choose-one.php');
		include apsro_get_template('choose-two.php');
		include apsro_get_template('choose-three.php');
	}
}
