<?php

namespace Layerdrops\Apsro\Widgets;


class Faq extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'apsro-faq';
	}

	public function get_title()
	{
		return __('FAQ', 'apsro-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['apsro-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'apsro-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'apsro-addon'),
					'layout_two' => __('Layout Two', 'apsro-addon'),
				]
			]
		);

		$this->end_controls_section();

		include apsro_get_elementor_option('faq-one-option.php');
		include apsro_get_elementor_option('faq-two-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .faq-page__left-text p', ['layout_one']);
		apsro_elementor_general_style_options($this, 'Subtitle', '{{WRAPPER}} .faq-page__left-text-2', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Contact Box Title', '{{WRAPPER}} .faq-page__contact-title', ['layout_one']);
		apsro_elementor_general_style_options($this, 'Contact Box Subtitle', '{{WRAPPER}} .faq-page__call-sub-title', ['layout_one']);

		apsro_elementor_general_style_options($this, 'Question', '{{WRAPPER}} .faq-page .faq-one-accrodion .accrodion-title h4,{{WRAPPER}} .faq-one-accrodion .accrodion-title h4', ['layout_one', 'layout_two']);
		apsro_elementor_general_style_options($this, 'Answer', '{{WRAPPER}} .faq-page .faq-one-accrodion .accrodion-content p,{{WRAPPER}} .faq-one-accrodion .accrodion-content p', ['layout_one', 'layout_two']);

		$this->end_controls_section();
		//button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => ['layout_one']
				]
			]
		);

		apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include apsro_get_template('faq-one.php');
		include apsro_get_template('faq-two.php');
	}
}
