<?php

namespace Layerdrops\Apsro\Widgets;


class Feature extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-feature';
    }

    public function get_title()
    {
        return __('Feature', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    'layout_three' => __('Layout Three', 'apsro-addon'),
                    'layout_four' => __('Layout Four', 'apsro-addon'),
                    'layout_five' => __('Layout Five', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('feature-one-option.php');
        include apsro_get_elementor_option('feature-two-option.php');
        include apsro_get_elementor_option('feature-three-option.php');
        include apsro_get_elementor_option('feature-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .feature-three__title,{{WRAPPER}} .feature-three__title', ['layout_one', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .feature-one__title a,{{WRAPPER}} .feature-two__hover-title a,{{WRAPPER}} .feature-two__title h3', ['layout_two', 'layout_four']);
        apsro_elementor_general_style_options($this, 'Subtitle', '{{WRAPPER}} .feature-one__text', ['layout_two']);

        $this->end_controls_section();
        apsro_elementor_column_count_options($this, ['layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('feature-one.php');
        include apsro_get_template('feature-two.php');
        include apsro_get_template('feature-three.php');
        include apsro_get_template('feature-four.php');
        include apsro_get_template('feature-five.php');
    }
}
