<?php

namespace Layerdrops\Apsro\Widgets;


class FooterNavMenu extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-nav-menu';
    }

    public function get_title()
    {
        return __('Footer Nav Menus', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    // 'layout_two' => __('Layout Two', 'apsro-addon'),
                    // 'layout_three' => __('Layout Three', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('footer-nav-one-option.php');
        // include apsro_get_elementor_option('footer-nav-two-option.php');
        // include apsro_get_elementor_option('footer-nav-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .footer-widget__title', ['layout_one', 'layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Nav', '{{WRAPPER}} .footer-widget__link-list li a', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('footer-nav-menu-one.php');
        // include apsro_get_template('footer-nav-menu-two.php');
        // include apsro_get_template('footer-nav-menu-three.php');
    }
}
