<?php

namespace Layerdrops\Apsro\Widgets;


class Header extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-header';
    }

    public function get_title()
    {
        return __('Header', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout Type', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    'layout_three' => __('Layout Three', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('header-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Menu', '{{WRAPPER}} .main-menu .main-menu__list > li > a,{{WRAPPER}} .main-menu .main-menu__list > li > ul > li > a', ['layout_one', 'layout_two', 'layout_three']);
        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('header.php');
    }
}
