<?php

namespace Layerdrops\Apsro\Widgets;


class MainSlider extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-main-slider';
    }

    public function get_title()
    {
        return __('Main Slider', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    'layout_three' => __('Layout Three', 'apsro-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include apsro_get_elementor_option('main-slider-one-option.php');
        include apsro_get_elementor_option('main-slider-two-option.php');
        include apsro_get_elementor_option('main-slider-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .main-slider__title,{{WRAPPER}} .main-slider-two__title-1,{{WRAPPER}} .main-slider-two__title-2,{{WRAPPER}} .main-slider-three__title-one', ['layout_one', 'layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Title Two', '{{WRAPPER}} .main-slider-three__title-two', ['layout_three']);
        apsro_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .main-slider__text-box,{{WRAPPER}} .main-slider-two__sub-title,{{WRAPPER}} .main-slider-three__sub-title', ['layout_one', 'layout_two']);
        apsro_elementor_general_style_options($this, 'Highlight Text', '{{WRAPPER}} .main-slider__title span:before', ['layout_one'], 'background-color');
        apsro_elementor_general_style_options($this, 'Star Text', '{{WRAPPER}} .main-slider-two__title-1 span', ['layout_two']);
        apsro_elementor_general_style_options($this, 'Phone', '{{WRAPPER}} .main-slider__phone a,{{WRAPPER}} .main-slider-two__phone a,{{WRAPPER}} .main-slider-three__contact-info li p a', ['layout_one', 'layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Mail', '{{WRAPPER}} .main-slider__mail a,{{WRAPPER}} .main-slider-two__mail a,{{WRAPPER}} .main-slider-three__contact-info li p', ['layout_one', 'layout_two', 'layout_three']);
        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .main-slider__btn-one, {{WRAPPER}} .main-slider-two__btn-one', '{{WRAPPER}} .thm-btn::before', ['layout_one', 'layout_two']);
        apsro_elementor_button_style_options($this, 'Button Two', '{{WRAPPER}} .main-slider__btn-two.thm-btn, {{WRAPPER}} .main-slider-two__btn-two.thm-btn', '{{WRAPPER}} .thm-btn::before,{{WRAPPER}} .main-slider-two__btn-two.thm-btn:before', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        apsro_get_elementor_carousel_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('main-slider-one.php');
        include apsro_get_template('main-slider-two.php');
        include apsro_get_template('main-slider-three.php');
    }
}
