<?php

namespace Layerdrops\Apsro\Widgets;


class Neighborhoods extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-neighborhood';
    }

    public function get_title()
    {
        return __('Neighborhood', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('neighborhood-one-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);

        apsro_elementor_general_style_options($this, 'Accordian Title', '{{WRAPPER}} .faq-one-accrodion .accrodion-title h4', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Accordian Summary', '{{WRAPPER}} .faq-one-accrodion .accrodion-content p', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Accordian Title Active', '{{WRAPPER}} .faq-one-accrodion .accrodion.active .accrodion-title h4', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('neighborhood-one.php');
    }
}
