<?php

namespace Layerdrops\Apsro\Widgets;


class Portfolio extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-portfolio';
    }

    public function get_title()
    {
        return __('Portfolio', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    'layout_three' => __('Layout Three', 'apsro-addon'),
                    'layout_four' => __('Layout Four', 'apsro-addon'),
                    'layout_five' => __('Layout Five', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('portfolio-one-option.php');
        include apsro_get_elementor_option('portfolio-two-option.php');
        include apsro_get_elementor_option('portfolio-three-option.php');
        include apsro_get_elementor_option('portfolio-four-option.php');
        include apsro_get_elementor_option('portfolio-five-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_two', 'layout_three', 'layout_four']);
        apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_two', 'layout_three', 'layout_four']);

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .portfolio-one__title a,{{WRAPPER}} .portfolio-two__list-content p a,{{WRAPPER}} .portfolio-three__title a,{{WRAPPER}} .smillar-portfolio__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        apsro_elementor_general_style_options($this, 'Tag Line', '{{WRAPPER}} .portfolio-one__sub-title,{{WRAPPER}} .smillar-portfolio__sub-title', ['layout_one', 'layout_four']);
        apsro_elementor_general_style_options($this, 'Number', '{{WRAPPER}} .portfolio-two__list-content span', ['layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('portfolio-one.php');
        include apsro_get_template('portfolio-two.php');
        include apsro_get_template('portfolio-three.php');
        include apsro_get_template('portfolio-four.php');
        include apsro_get_template('portfolio-five.php');
    }
}
