<?php

namespace Layerdrops\Apsro\Widgets;


class Pricing extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-pricing';
    }

    public function get_title()
    {
        return __('Pricing', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include apsro_get_elementor_option('pricing-one-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);

        apsro_elementor_general_style_options($this, 'Heading', '{{WRAPPER}} .pricing-page__main-tab-box .tab-buttons .tab-btn.active-btn span', ['layout_one']);

        apsro_elementor_general_style_options($this, 'Plan Title', '{{WRAPPER}} .pricing-page__price-sub-title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Price', '{{WRAPPER}} .pricing-page__price', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Service Heading', '{{WRAPPER}} .pricing-page__title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Service List', '{{WRAPPER}} .pricing-page__service-list li .text p', ['layout_one']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one']
                ]
            ]
        );

        apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn:before', ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('pricing-one.php');
    }
}
