<?php

namespace Layerdrops\Apsro\Widgets;


class ProgressBar extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'apsro-progress-bar';
	}

	public function get_title()
	{
		return __('Progress Bar', 'apsro-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['apsro-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'apsro-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'apsro-addon'),
				]
			]
		);

		$this->end_controls_section();

		include apsro_get_elementor_option('progress-bar-one-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .experience-one__progress-title', ['layout_one']);
		apsro_elementor_general_style_options($this, 'Count', '{{WRAPPER}} .experience-one__progress .count-text', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include apsro_get_template('progress-bar-one.php');
	}
}
