<?php

namespace Layerdrops\Apsro\Widgets;


class Register extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-register';
    }

    public function get_title()
    {
        return __('Register', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Register ', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'email_placeholder',
            [
                'label' => __('Email Placeholder', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Email Address', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'password_placeholder',
            [
                'label' => __('Placeholder for Password', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Password* ', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'privacy_text',
            [
                'label' => __('Privacy Text', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('I accept company <a href="#">privacy policy</a>.', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'register_btn_text',
            [
                'label' => __('Register Button Text', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Register', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .login-page__title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Privacy', '{{WRAPPER}} .login-page__form .checked-box label,{{WRAPPER}} .login-page__form .checked-box label a', ['layout_one']);

        apsro_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn::before', ['layout_one']);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('register-one.php');
    }
}
