<?php

namespace Layerdrops\Apsro\Widgets;


class Service extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-service';
    }

    public function get_title()
    {
        return __('Service', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    'layout_three' => __('Layout Three', 'apsro-addon'),
                    // 'layout_four' => __('Layout Four', 'apsro-addon'),
                    // 'layout_five' => __('Layout Five', 'apsro-addon'),
                    // 'layout_six' => __('Layout Six', 'apsro-addon'),
                    // 'layout_seven' => __('Layout Seven', 'apsro-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include apsro_get_elementor_option('service-one-option.php');
        include apsro_get_elementor_option('service-two-option.php');
        include apsro_get_elementor_option('service-three-option.php');
        // include apsro_get_elementor_option('service-four-option.php');
        // include apsro_get_elementor_option('service-five-option.php');
        // include apsro_get_elementor_option('service-six-option.php');
        // include apsro_get_elementor_option('service-seven-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_two', 'layout_three']);
        apsro_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .services-two__text,{{WRAPPER}} .services-three__text', ['layout_two', 'layout_three']);

        apsro_elementor_general_style_options($this, 'Service Title', '{{WRAPPER}} .services-one__hover-title a,{{WRAPPER}} .services-one__title a,{{WRAPPER}} .services-two__title a,{{WRAPPER}} .services-three__single:hover,{{WRAPPER}} .services-three__title a', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
        apsro_elementor_column_count_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('service-one.php');
        include apsro_get_template('service-two.php');
        include apsro_get_template('service-three.php');
        // include apsro_get_template('service-four.php');
        // include apsro_get_template('service-five.php');
        // include apsro_get_template('service-six.php');
        // include apsro_get_template('service-seven.php');
    }
}
