<?php

namespace Layerdrops\Apsro\Widgets;


class SidebarDownload extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-download';
    }

    public function get_title()
    {
        return __('Sidebar Download', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $download_items = new \Elementor\Repeater();

        $download_items->add_control(
            'title',
            [
                'label' => __('Title', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Control Self Esteem', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        apsro_elementor_heading_option($download_items, 'Title', 'h3', 'layout_one');

        $download_items->add_control(
            'url',
            [
                'label' => __('File Url', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'apsro-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $download_items->add_control(
            'file_size',
            [
                'label' => __('File Size', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('3.9KB', 'apsro-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'download_items',
            [
                'label' => __('Download Items', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $download_items->get_controls(),
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .services-details__documents .content h3 a', ['layout_one']);
        apsro_elementor_general_style_options($this, 'File Size', '{{WRAPPER}} .services-details__documents .content p', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('sidebar-download-one.php');
    }
}
