<?php

namespace Layerdrops\Apsro\Widgets;


class Sponsors extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-sponsors';
    }

    public function get_title()
    {
        return __('Sponsors', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    // 'layout_two' => __('Layout Two', 'apsro-addon'),
                    // 'layout_three' => __('Layout Three', 'apsro-addon'),
                    // 'layout_four' => __('Layout Four', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_one_sec_title',
            [
                'label' => __('Title', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('Add title', 'apsro-addon'),
                'default' => __('Default Title', 'apsro-addon'),
            ]
        );

        apsro_elementor_heading_option($this, 'Sponsor Title', 'h4', 'layout_one');

        $sponsor_images = new \Elementor\Repeater();

        $sponsor_images->add_control(
            'image',
            [
                'label' => __('Add Image', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'sponsor_images',
            [
                'label' => __('Sponsor Items', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $sponsor_images->get_controls(),
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .brand-one__title', ['layout_one']);

        $this->end_controls_section();

        apsro_get_elementor_carousel_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('sponsors-one.php');
        // include apsro_get_template('sponsors-two.php');
        // include apsro_get_template('sponsors-three.php');
        // include apsro_get_template('sponsors-four.php');
    }
}
