<?php

namespace Layerdrops\Apsro\Widgets;


class Tab extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'apsro-tab';
	}

	public function get_title()
	{
		return __('Tab', 'apsro-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['apsro-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'apsro-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'apsro-addon'),
				]
			]
		);

		$this->end_controls_section();

		include apsro_get_elementor_option('tab-one-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		apsro_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .tabs-one__content h3', ['layout_one']);
		apsro_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .tabs-one__content p', ['layout_one']);


		$this->end_controls_section();

		//button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'apsro-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);

		apsro_elementor_button_style_options($this, 'Tab Button', '{{WRAPPER}} .tabs-one__inner .tab-buttons .tab-btn span', '{{WRAPPER}} .tabs-one__inner .tab-buttons .tab-btn span', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include apsro_get_template('tab-one.php');
	}
}
