<?php

namespace Layerdrops\Apsro\Widgets;


class Team extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-team';
    }

    public function get_title()
    {
        return __('Team', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('team-one-option.php');
        include apsro_get_elementor_option('team-two-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);

        apsro_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .team-one__name-box h3 a,{{WRAPPER}} .team-one__name-box h3 a', ['layout_one', 'layout_two']);
        apsro_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .team-one__name-box p,{{WRAPPER}} .team-one__name-box p', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        apsro_elementor_column_count_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('team-one.php');
        include apsro_get_template('team-two.php');
    }
}
