<?php

namespace Layerdrops\Apsro\Widgets;


class Testimonials extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-testimonials';
    }

    public function get_title()
    {
        return __('Testimonials', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {


        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    // 'layout_three' => __('Layout Three', 'apsro-addon'),
                    // 'layout_four' => __('Layout Four', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('testimonial-one-option.php');
        include apsro_get_elementor_option('testimonial-two-option.php');
        // include apsro_get_elementor_option('testimonial-three-option.php');
        // include apsro_get_elementor_option('testimonial-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title,{{WRAPPER}} .case-details__review-title', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .testimonial-one__left-text', ['layout_one']);
        apsro_elementor_general_style_options($this, 'Rating Title', '{{WRAPPER}} .testimonial-one__ratting-box p,{{WRAPPER}} .testimonial-two__ratting-title', ['layout_one']);

        apsro_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .testimonial-one__client-info h3,{{WRAPPER}} .testimonial-two__client-name', ['layout_one', 'layout_two']);
        apsro_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .testimonial-one__client-info p,{{WRAPPER}} .testimonial-two__client-name span', ['layout_one', 'layout_two']);
        apsro_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .testimonial-one__text,{{WRAPPER}} .testimonial-two__text', ['layout_one', 'layout_two']);


        $this->end_controls_section();

        apsro_get_elementor_carousel_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('testimonials-one.php');
        include apsro_get_template('testimonials-two.php');
        // include apsro_get_template('testimonials-three.php');
        // include apsro_get_template('testimonials-four.php');
    }
}
