<?php

namespace Layerdrops\Apsro\Widgets;


class Video extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'apsro-video';
    }

    public function get_title()
    {
        return __('Video', 'apsro-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['apsro-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'apsro-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'apsro-addon'),
                    'layout_two' => __('Layout Two', 'apsro-addon'),
                    // 'layout_three' => __('Layout Three', 'apsro-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include apsro_get_elementor_option('video-one-option.php');
        include apsro_get_elementor_option('video-two-option.php');
        // include apsro_get_elementor_option('video-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'apsro-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        apsro_elementor_general_style_options($this, 'Curved Title', '{{WRAPPER}} .video-one__curved-circle-box .curved-circle,{{WRAPPER}} .video-two__curved-circle-box .curved-circle-2', ['layout_one', 'layout_two']);
        apsro_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .video-two__title', ['layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include apsro_get_template('video-one.php');
        include apsro_get_template('video-two.php');
        // include apsro_get_template('video-three.php');
    }
}
