<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package apsro
 */

get_header();


?>

<?php if ('yes' == get_theme_mod('error_custom')) : ?>
    <?php echo do_shortcode(\Elementor\Plugin::$instance->frontend->get_builder_content(get_theme_mod('error_custom_post'))); ?>
<?php else : ?>
    <main id="primary" class="site-main">
        <!--Error Page Start-->
        <section class="error-page">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="error-page__inner">
                            <div class="error-page__title-box">
                                <?php if (!empty(get_theme_mod('404_page_title_image'))) : ?>
                                    <div class="error-page__title-shape-1 img-bounce">
                                        <img src="<?php echo esc_url(get_theme_mod('404_page_title_image')); ?>" alt="<?php echo esc_attr('404 image', 'pitoon'); ?>">
                                    </div>
                                    <h2 class="error-page__title"><?php echo esc_html_e("4", "apsro"); ?> <span><?php echo esc_html_e("4", "apsro"); ?></span></h2>
                                <?php else : ?>
                                    <h2 class="error-page__title"><?php esc_html_e('404', 'apsro'); ?></h2>
                                <?php endif; ?>
                            </div>
                            <h3 class="error-page__tagline"><?php esc_html_e('Oops! Page Not Found', 'apsro'); ?></h3>
                            <p class="error-page__text"><?php esc_html_e('The page you are looking for is not exist.', 'apsro'); ?></p>
                            <form class="error-page__form" method="get" action="<?php echo esc_url(home_url()); ?>">
                                <div class="error-page__form-input">
                                    <input type="search" placeholder="<?php esc_attr_e('Search Here', 'apsro'); ?>">
                                    <button type="submit"><i class="icon-magnifying-glass"></i></button>
                                </div>
                            </form>
                            <div class="error-page__btn-box">
                                <a href="<?php echo esc_url(home_url('/')); ?>"" class=" thm-btn error-page__btn"><?php echo esc_html_e("Back to Home", 'apsro'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Error Page End-->
    </main><!-- #main -->
<?php endif; ?>

<?php
get_footer();
