<?php

/**
 * apsro functions for getting inline styles from theme customizer
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package apsro
 */

if (!function_exists('apsro_theme_customizer_styles')) :
	function apsro_theme_customizer_styles()
	{

		// apsro color option

		$apsro_inline_style = '';
		$apsro_inline_style .= ':root {
			--apsro-primary: ' . get_theme_mod('theme_primary_color', sanitize_hex_color('#f2edea')) . ';
			--apsro-primary-rgb: ' . apsro_hex_to_rgb(get_theme_mod('theme_primary_color', sanitize_hex_color('#f2edea'))) . ';

			--apsro-base: ' . get_theme_mod('theme_base_color', sanitize_hex_color('#976147')) . ';
			--apsro-base-rgb: ' . apsro_hex_to_rgb(get_theme_mod('theme_base_color', sanitize_hex_color('#976147'))) . ';

			--apsro-black: ' . get_theme_mod('theme_black_color', sanitize_hex_color('#1a1414')) . ';
			--apsro-black-rgb: ' . apsro_hex_to_rgb(get_theme_mod('theme_black_color', sanitize_hex_color('#1a1414'))) . ';
		}';

		$apsro_inner_banner_bg = get_theme_mod('page_header_bg_image');
		$apsro_inline_style .= '.page-header-bg { background-image: url(' . $apsro_inner_banner_bg . '); } ';

		$apsro_preloader_icon = get_theme_mod('preloader_image');
		if ($apsro_preloader_icon) {
			$apsro_inline_style .= '.preloader .preloader__image { background-image: url(' . $apsro_preloader_icon . '); } ';
		}

		if (is_page()) {


			$apsro_page_primary_color = empty(get_post_meta(get_the_ID(), 'apsro_primary_color', true)) ? get_theme_mod('theme_primary_color', sanitize_hex_color('#f2edea')) : get_post_meta(get_the_ID(), 'apsro_primary_color', true);

			$apsro_page_base_color = empty(get_post_meta(get_the_ID(), 'apsro_base_color', true)) ? get_theme_mod('theme_base_color', sanitize_hex_color('#976147')) : get_post_meta(get_the_ID(), 'apsro_base_color', true);

			$apsro_page_black_color = empty(get_post_meta(get_the_ID(), 'apsro_black_color', true)) ? get_theme_mod('theme_black_color', sanitize_hex_color('#1a1414')) : get_post_meta(get_the_ID(), 'apsro_black_color', true);

			$apsro_inline_style .= ':root {
				--apsro-primary: ' . $apsro_page_primary_color . ';
				--apsro-primary-rgb: ' . apsro_hex_to_rgb($apsro_page_primary_color) . ';
				--apsro-base: ' . $apsro_page_base_color . ';
				--apsro-base-rgb: ' . apsro_hex_to_rgb($apsro_page_base_color) . ';
				--apsro-black: ' . $apsro_page_black_color . ';
				--apsro-black-rgb: ' . apsro_hex_to_rgb($apsro_page_black_color) . ';
			}';

			$apsro_page_header_bg = empty(get_post_meta(get_the_ID(), 'apsro_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'apsro_set_header_image', true);

			$apsro_inline_style .= '.page-header-bg { background-image: url(' . $apsro_page_header_bg . '); }';
		}

		if (is_singular('post')) {
			$apsro_post_header_bg = empty(get_post_meta(get_the_ID(), 'apsro_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'apsro_set_header_image', true);

			$apsro_inline_style .= '.page-header-bg  { background-image: url(' . $apsro_post_header_bg . '); }';
		}


		wp_add_inline_style('apsro-style', $apsro_inline_style);
	}
endif;

add_action('wp_enqueue_scripts', 'apsro_theme_customizer_styles');
