<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apsro
 */

$tag_name = get_the_tags();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-sidebar__single'); ?>>
	<div class="blog-sidebar__single">
		<?php if (has_post_thumbnail()) : ?>
			<div class="blog-sidebar__img<?php if (function_exists('apsro_elementor_rendered_image')) {
												echo esc_attr(" blend_mode");
											} ?>">
				<?php the_post_thumbnail('apsro_blog_770X428');  ?>
				<div class="blog-sidebar__date-box">
					<p><?php echo get_the_date(); ?></p>
				</div>
			</div>
		<?php endif; ?>
		<div class="blog-sidebar__content">
			<ul class="blog-details__meta list-unstyled ml-0">
				<?php if (has_tag()) : ?>
					<li><a href="<?php the_permalink(); ?>"><i class="fas fa-tags"></i><?php echo esc_html($tag_name[0]->name); ?></a>
					</li>
				<?php endif; ?>
				<li>
					<?php apsro_comment_count(); ?>
				</li>
			</ul>
			<h3 class="blog-sidebar__title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h3>
			<?php $apsro_excerpt_count = apply_filters('apsro_excerpt_count', 39); ?>
			<p class="blog-sidebar__text"><?php apsro_excerpt($apsro_excerpt_count); ?></p>
			<div class="blog-sidebar__arrow">
				<a href="<?php the_permalink(); ?>"><span class="icon-right-lg-arrow"></span></a>
			</div>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->