<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apsro
 */
$tag_name = get_the_tags();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if (has_post_thumbnail()) : ?>
		<div class="blog-details__img<?php if (function_exists('apsro_elementor_rendered_image')) {
											echo esc_attr(" blend_mode");
										} ?>">
			<?php the_post_thumbnail('apsro_blog_770X428');  ?>
			<div class="blog-details__date-box">
				<p><?php echo get_the_date(); ?></p>
			</div>
		</div>
	<?php endif; ?>
	<div class="blog-details__content">
		<ul class="blog-details__meta list-unstyled ml-0">
			<?php if (has_tag()) : ?>
				<li><a href="<?php the_permalink(); ?>"><i class="fas fa-tags"></i><?php echo esc_html($tag_name[0]->name); ?></a>
				</li>
			<?php endif; ?>
			<li>
				<?php apsro_comment_count(); ?>
			</li>
		</ul>
		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'apsro'),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post(get_the_title())
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__('Pages:', 'apsro'),
				'after'  => '</div>',
			)
		);
		?>

	</div>
	<div class="blog-details__bottom">
		<?php apsro_entry_footer(); ?>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->