<?php

/**
 * Template part for displaying footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apsro
 */
?>


<?php
$apsro_page_id     = get_queried_object_id();
$apsro_custom_footer_status = !empty(get_post_meta($apsro_page_id, 'apsro_custom_footer_status', true)) ? get_post_meta($apsro_page_id, 'apsro_custom_footer_status', true) : 'off';

$apsro_custom_footer_id = '';
if ((is_page() && 'on' === $apsro_custom_footer_status) || (is_singular('portfolio') && 'on' === $apsro_custom_footer_status) || (is_singular('service') && 'on' === $apsro_custom_footer_status) || (is_singular('team') && 'on' === $apsro_custom_footer_status)) {
    $apsro_custom_footer_id = get_post_meta($apsro_page_id, 'apsro_select_custom_footer', true);
} elseif ('yes' == get_theme_mod('footer_custom')) {
    $apsro_custom_footer_id = get_theme_mod('footer_custom_post');
} else {
    $apsro_custom_footer_id = 'default_footer';
}

$apsro_dynamic_footer = isset($_GET['custom_footer_id']) ? $_GET['custom_footer_id'] : $apsro_custom_footer_id;
?>


<?php if ('default_footer' == $apsro_dynamic_footer) : ?>
    <div class="site-footer__bottom default-footer">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-footer__bottom-inner">
                        <p class="site-footer__bottom-text"><?php echo wp_kses(get_theme_mod('footer_copytext', esc_html__('&copy; All Copyright 2023 by Apsro', 'apsro')), 'apsro_allowed_tags'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <?php echo do_shortcode('[apsro-footer id="' . $apsro_dynamic_footer . '"]');
    ?>
<?php endif; ?>