<?php
/**
 * Plugin Name: Advanced Comparison Table for Elementor
 * Description: Advanced Comparison Table for Elementor is an affiliate marketing featured rich WordPress plugin having all the required features in one place.
 * Plugin URI: https://www.coderkart.com/downloads/advanced-comparison-table-for-elementor/
 * Author: Coderkart Technologies
 * Version: 1.0.6
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Elementor tested up to: 3.28.3
 * Elementor Pro tested up to: 3.28.2
 *
 * Author URI: https://www.coderkart.com
 *
 * Text Domain: advanced-comparison-table-for-elementor
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Define Plugin URL and Directory Path
 */
define('ACTE_URL', plugins_url('/', __FILE__));  // Define Plugin URL
define('ACTE_PATH', plugin_dir_path(__FILE__));  // Define Plugin Directory Path
define('ACTE_DOMAIN', 'advanced-comparison-table-for-elementor'); // Define Text Domain
define('ACTE_SITE', home_url()); // Define Home URL
define('ACTE_NAME', 'Advanced Comparison Table for Elementor'); // Define Name

/**
 * Main Plugin Advanced Comparison Table for Elementor class.
 * 
 * @access public
 * @since  1.0
 */
if (!class_exists('ACTE_Comparison_Table')) :
class ACTE_Comparison_Table {

	/**
     * ACTE constructor.
     * The main plugin actions registered for WordPress
     * 
     * @access public
     * @since  1.0
    */
    public function __construct() {	
		$this->hooks();	
		require_once ACTE_PATH . 'widgets/elementor-helper.php';
		require_once ACTE_PATH . 'widgets/elementor-dependency.php';
    }

	/**
	* Initialize
	*/
	public function hooks() {
        add_action('elementor/widgets/register', array($this, 'acte_widget_register'));
        add_action('wp_enqueue_scripts', array($this, 'acte_widget_script_register'));
		add_action('plugins_loaded', array($this, 'acte_elements_plugin_load'));
	}

	/**
	 * Register the widgets file in elementor widgets.
	 */
	public function acte_widget_register() {
		require_once ACTE_PATH . 'widgets/comparison-table.php';
		require_once ACTE_PATH . 'include/comparison-functions.php';
	}

	/**
	 * Load scripts and styles
	 */
	public function acte_widget_script_register() {
		wp_register_style('acte-style', ACTE_URL . 'assets/css/advanced-comparison-table.css', array(), '1.0.0');
		wp_register_script('acte-script', ACTE_URL . 'assets/js/advanced-comparison-table.js', array('jquery'), '1.0.0', true);
	}
	/**
	 * Check for Elementor
	 */
	public function acte_elements_plugin_load() {
		// Load plugin textdomain
		load_plugin_textdomain('ACTE_DOMAIN');

		if (!did_action('elementor/loaded')) {
			add_action('admin_notices', array($this, 'acte_elements_widget_fail_load'));
			return;
		}
	}

	/**
	 * This notice will appear if Elementor is not installed or activated or both
	 */
	public function acte_elements_widget_fail_load() {
		$screen = get_current_screen();
		if (isset($screen->parent_file) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id) {
			return;
		}

		$plugin = 'elementor/elementor.php';

		if (acte_elementor_installed()) {
			if (!current_user_can('activate_plugins')) {
				return;
			}
			$activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin);

			$message = '<p><strong>' . esc_html__('Advanced Comparison Table for Elementor', 'advanced-comparison-table-for-elementor').'</strong>'. esc_html__(' not working because you need to activate the Elementor plugin.', 'advanced-comparison-table-for-elementor') . '</p>';
			$message .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $activation_url, esc_html__('Activate Elementor Now', 'advanced-comparison-table-for-elementor')) . '</p>';
		} else {
			if (!current_user_can('install_plugins')) {
				return;
			}

			$install_url = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=elementor'), 'install-plugin_elementor');

			$message = '<p><strong>' . esc_html__('Advanced Comparison Table for Elementor', 'advanced-comparison-table-for-elementor').'</strong>'. esc_html__(' not working because you need to install the Elementor plugin', 'advanced-comparison-table-for-elementor') . '</p>';
			$message .= '<p>' . sprintf('<a href="%s" class="button-primary">%s</a>', $install_url, esc_html__('Install Elementor Now', 'advanced-comparison-table-for-elementor')) . '</p>';
		}

		echo '<div class="error"><p>' . wp_kses_post($message) . '</p></div>';
	}
	
}
endif;

/**
 * Initialize Plugin Class
 *
 * @access public
 * @since  1.0
 */
new ACTE_Comparison_Table();