<!-- Start Advanced Comparison Table Style 1 -->
<div class="acte ct-style-1">
    <ul><?php
    // Tab Title.
        for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
            <li class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></li>
        <?php } ?>
    </ul>
    <table>
        <tbody>
            <!-- Header -->
            <tr class="ct-header">
                <!-- Title -->
                <td class="ct-features-heading"><?php echo esc_html($settings['ct_feature_heading']); ?></td>
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>">
                        <?php
                        // Currency Symbol.
                        if ('ct_custom' !== $settings['ac_currency_symbol_' . $i]) {
                            $ct_price_symbol = ac_get_currency_symbol($settings['ac_currency_symbol_' . $i]);
                        } else {
                            $ct_price_symbol = $settings['ct_currency_text_symbol_' .$i];
                        } ?>
                        <!-- Price -->
                        <span class="ct-feature ct-product-price"><?php echo esc_html($ct_price_symbol . $settings['ct_product_price_' . $i]); ?></span>
                        <?php if (!empty($settings['ct_product_image_' . $i]['url'])) { ?>
                            <img class="ct-product-img" src="<?php echo esc_url($settings['ct_product_image_' . $i]['url']); ?>" />
                        <?php } ?>
                        <svg viewBox="0 0 507 410" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 0H507V348.217L250.509 409.402L0 348.217V0Z"/>
                        </svg>
                    </td>
                <?php } ?>
            </tr>
            <?php
            // Features.
            $count = count( $settings['ct_feature_list'] );
            for ( $x = 1; $x <= $count; $x++ ) { ?>
                <tr>
                    <!-- Feature Title -->
                    <td class="ct-feature-heading"><?php echo esc_html($settings['ct_feature_list'][ $x - 1 ]['ct_feature']); ?></td>
                    <?php for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) { ?>
                        <!-- Feature Content -->
                        <td class="ct-feature ct-product-<?php echo esc_attr($j); ?>"><?php
                            if ( count( $settings[ 'ct_feature_list_' . $j ] ) >= $x ) {
                                if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'text' && $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'icon') {
                                    if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'fa fa-close' ) { ?>
                                        <i class="ct-mark-no <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    } else { ?>
                                        <i class="ct-mark-yes <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    }
                                } elseif ($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'icon') {
                                    ?><i class="<?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_icon']['value']);?>"></i><?php
                                } else {
                                    echo esc_html($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_text']);
                                }
                            } else {
                                echo '';
                            } ?>
                        </td>
                    <?php } ?>
                </tr>
            <?php } ?>
            <!-- Button -->
            <tr>
                <!-- Button Title -->
                <?php if($settings['ct_feature_heading_button'] != ""){ ?>
                    <td class="ct-feature-heading ct-feature-heading-button"><?php echo esc_html($settings['ct_feature_heading_button']); ?></td>
                <?php } else { ?>
                    <td class="ct-blank-heading"></td>
                <?php }
                // Button.
                for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) {
                    $button_link    = $settings['ct_product_link_' . $j]['url'];
                    $target         = $settings['ct_product_link_' . $j]['is_external'] ? ' target="_blank"' : '';
                    $rel            = $settings['ct_product_link_' . $j]['nofollow'] ? ' rel="nofollow"' : ''; ?>
                    <td class="ct-feature-button ct-product-<?php echo esc_attr($j); ?>">
                        <?php if ( $settings[ 'ct_button_text_' . $j ] !== '' ) { ?>
                            <a class="ct-product-btn" href="<?php echo esc_url($button_link); ?>" <?php echo esc_attr($target); echo esc_attr($rel);?>><?php echo esc_html($settings['ct_button_text_' . $j]); ?></a>
                        <?php } ?>
                    </td>
                <?php } ?>
            </tr>
        </tbody>
    </table>
</div>
<!-- End Advanced Comparison Table Style 1 -->