<!-- Start Advanced Comparison Table Style 3 -->
<div class="acte ct-style-3">
    <ul><?php
    // Tab Title.
        for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
            <li class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></li>
        <?php } ?>
    </ul>
    <table>
        <tbody>
            <!-- Header -->
            <tr class="ct-header">
                <!-- Title -->
                <td class="ct-features-heading"><?php echo esc_html($settings['ct_feature_heading']); ?></td>
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>">
                    <!-- Image -->
                        <?php if (!empty($settings['ct_product_image_' . $i]['url'])) { ?>
                            <div class="ct-product-image">
                                <img class="ct-product-img" src="<?php echo esc_url($settings['ct_product_image_' . $i]['url']); ?>" />
                            </div>
                        <?php }
                        if (!empty($settings['ct_product_title_' . $i]) || !empty($settings['ct_product_price_' . $i])) { ?>
                            <div class="ct-title-wrapper">
                                <!-- Title -->
                                <?php if (!empty($settings['ct_product_title_' . $i])) { ?>
                                    <div class="ct-product-title"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></div>
                                <?php } ?>
                                <?php if (!empty($settings['ct_product_price_' . $i])) {
                                    // Currency Symbol.
                                    if ('ct_custom' !== $settings['ac_currency_symbol_' . $i]) {
                                        $ct_price_symbol = ac_get_currency_symbol($settings['ac_currency_symbol_' . $i]);
                                    } else {
                                        $ct_price_symbol = $settings['ct_currency_text_symbol_' .$i];
                                    } ?>
                                    <!-- Price -->
                                    <div class="ct-feature ct-product-price"><?php echo esc_html($ct_price_symbol . $settings['ct_product_price_' . $i]); ?></div>
                                <?php } ?>
                            </div>
                            <?php
                        } ?>                                           
                    </td>
                <?php } ?>
            </tr>
            <?php
            // Featuers.
            $count = count( $settings['ct_feature_list'] );
            for ( $x = 1; $x <= $count; $x++ ) { ?>
                <tr>
                    <!-- Feature Title. -->
                    <td class="ct-feature-heading"><?php echo esc_html($settings['ct_feature_list'][ $x - 1 ]['ct_feature']); ?></td>
                    <?php for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) { ?>
                        <!-- Feature Content. -->
                        <td class="ct-feature ct-product-<?php echo esc_attr($j); ?>"><?php
                            if ( count( $settings[ 'ct_feature_list_' . $j ] ) >= $x ) {
                                if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'text' && $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'icon') {
                                    if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'fa fa-close' ) { ?>
                                        <i class="ct-mark-no <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    } else { ?>
                                        <i class="ct-mark-yes <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    }
                                } elseif ($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'icon') {
                                    ?><i class="<?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_icon']['value']);?>"></i><?php
                                } else {
                                    echo esc_html($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_text']);
                                }
                            } else {
                                echo '';
                            } ?>
                        </td>
                    <?php } ?>
                </tr>
            <?php } ?>
            <!-- Button -->
            <tr>
                <!-- Button Title -->
                <?php if($settings['ct_feature_heading_button'] != ""){ ?>
                    <td class="ct-feature-heading ct-feature-heading-button"><?php echo esc_html($settings['ct_feature_heading_button']); ?></td>
                <?php } else { ?>
                    <td class="ct-blank-heading"></td>
                <?php }
                // Button.   
                for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-feature ct-product-button ct-product-<?php echo esc_attr($i); ?>">
                        <?php
                        $button_link    = $settings['ct_product_link_' . $i]['url'];
                        $target         = $settings['ct_product_link_' . $i]['is_external'] ? ' target="_blank"' : '';
                        $rel            = $settings['ct_product_link_' . $i]['nofollow'] ? ' rel="nofollow"' : ''; ?>
                        <div class="ct-feature-button ct-product-<?php echo esc_attr($i); ?>">
                            <?php if ( $settings[ 'ct_button_text_' . $i ] !== '' ) { ?>
                                <a class="ct-product-btn" href="<?php echo esc_url($button_link); ?>" <?php echo esc_attr($target); echo esc_attr($rel);?>><?php echo esc_html($settings['ct_button_text_' . $i]); ?></a>
                            <?php } ?>
                        </div>
                    </td>
                    <?php
                } ?>
            </tr>
        </tbody>
    </table>
</div>
<!-- End Advanced Comparison Table Style 3 -->