<!-- Start Advanced Comparison Table Style 4 -->
<div class="acte ct-style-4">
    <ul><?php
    // Tab Title.
        for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
            <li class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></li>
        <?php } ?>
    </ul>
    <table>
        <tbody>
            <!-- Header -->
            <tr class="ct-header">
                <!-- Title -->
                <td class="ct-features-heading" rowspan="2">
                    <div class="ct-design"><?php echo esc_html($settings['ct_feature_heading']); ?></div>
                </td>
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>">
                    <!-- Image -->
                        <?php if (!empty($settings['ct_product_image_' . $i]['url'])) { ?>
                            <img class="ct-product-img" src="<?php echo esc_url($settings['ct_product_image_' . $i]['url']); ?>" />
                        <?php }
                        // Title.
                        if (!empty($settings['ct_product_title_' . $i])) { ?>
                            <div class="ct-product-title"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></div>
                        <?php } ?>
                    </td>
                <?php } ?>
            </tr>
            <!-- Price -->
            <tr class="ct-price-header">
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td id="ct_price" class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>">
                        <?php if (!empty($settings['ct_product_price_' . $i])) { ?>
                            <div class="ct-product-price">
                                <svg viewBox="0 0 147 87" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M65.8962 1.90315C70.8815 0.0314983 76.3763 0.0314965 81.3616 1.90315L94.0455 6.66519C96.0384 7.41343 98.1294 7.86844 100.253 8.01601L113.168 8.91341C120.408 9.4165 126.873 13.6286 130.258 20.0483L130.836 21.1437C132.21 23.7494 134.259 25.938 136.769 27.4807L140.431 29.7321C146.677 33.5715 148.292 41.9372 143.925 47.8259V47.8259C142.087 50.3047 141.23 53.3761 141.521 56.4486L141.551 56.7708C142.154 63.1419 138.148 69.0436 132.005 70.8362L121.604 73.8712C118.989 74.6342 116.539 75.8763 114.377 77.5342L108.117 82.3359C103.474 85.8974 97.6031 87.4623 91.8032 86.6845L76.5532 84.6393C74.6123 84.379 72.6455 84.379 70.7047 84.6393L55.4546 86.6845C49.6547 87.4623 43.784 85.8974 39.1408 82.3359L32.8806 77.5342C30.7192 75.8763 28.2686 74.6342 25.6536 73.8712L15.2527 70.8362C9.10941 69.0436 5.10391 63.1419 5.70654 56.7708L5.73702 56.4486C6.02764 53.3761 5.17128 50.3047 3.33284 47.8259V47.8259C-1.03452 41.9372 0.580844 33.5715 6.8266 29.7321L10.4892 27.4807C12.9987 25.938 15.0477 23.7494 16.4217 21.1437L16.9994 20.0483C20.3847 13.6286 26.8496 9.4165 34.0898 8.91341L47.0047 8.01601C49.1284 7.86844 51.2194 7.41343 53.2123 6.66519L65.8962 1.90315Z"/>
                                </svg>
                                <?php
                                // Currency Symbol.
                                if ('ct_custom' !== $settings['ac_currency_symbol_' . $i]) {
                                    $ct_price_symbol = ac_get_currency_symbol($settings['ac_currency_symbol_' . $i]);
                                } else {
                                    $ct_price_symbol = $settings['ct_currency_text_symbol_' .$i];
                                } ?>
                                <!-- Price -->
                                <span><?php echo esc_html($ct_price_symbol . $settings['ct_product_price_' . $i]); ?></span>
                            </div>
                        <?php } ?>
                    </td>
                <?php } ?>
            </tr>
            <!-- Features -->
            <?php
            $count = count( $settings['ct_feature_list'] );
            for ( $x = 1; $x <= $count; $x++ ) { ?>
                <tr>
                    <!-- Feature Title -->
                    <td class="ct-feature-heading"><?php echo esc_html($settings['ct_feature_list'][ $x - 1 ]['ct_feature']); ?></td>
                    <?php for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) { ?>
                        <!-- Feature Content -->
                        <td class="ct-feature ct-product-<?php echo esc_attr($j); ?>"><?php
                        if ( count( $settings[ 'ct_feature_list_' . $j ] ) >= $x ) {
                            if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'text' && $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'icon') {
                                if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'fa fa-close' ) { ?>
                                    <i class="ct-mark-no <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                } else { ?>
                                    <i class="ct-mark-yes <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                }
                            } elseif ($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'icon') {
                                ?><i class="<?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_icon']['value']);?>"></i><?php
                            } else {
                                echo esc_html($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_text']);
                            }
                        } else {
                            echo '';
                        } ?></td>
                    <?php } ?>
                </tr>
            <?php } ?>
            <!-- Button -->
            <tr>
                <!-- Button Title -->
                <?php if($settings['ct_feature_heading_button'] != ""){ ?>
                    <td class="ct-feature-heading ct-feature-heading-button"><?php echo esc_html($settings['ct_feature_heading_button']); ?></td>
                <?php } else { ?>
                    <td class="ct-blank-heading"></td>
                <?php }
                // Button.
                for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) {
                    $button_link    = $settings['ct_product_link_' . $j]['url'];
                    $target         = $settings['ct_product_link_' . $j]['is_external'] ? ' target="_blank"' : '';
                    $rel            = $settings['ct_product_link_' . $j]['nofollow'] ? ' rel="nofollow"' : ''; ?>
                    <td class="ct-feature-button ct-product-<?php echo esc_attr($j); ?>">
                        <?php if ( $settings[ 'ct_button_text_' . $j ] !== '' ) { ?>
                            <a class="ct-product-btn" href="<?php echo esc_url($button_link); ?>" <?php echo esc_attr($target); echo esc_attr($rel);?>><?php echo esc_html($settings['ct_button_text_' . $j]); ?></a>
                        <?php } ?>
                    </td>
                <?php } ?>
            </tr>
        </tbody>
    </table>
</div>
<!-- End Advanced Comparison Table Style 4 -->