<!-- Start Advanced Comparison Table Style 5 -->
<div class="acte ct-style-5">
    <ul><?php
    // Tab Title.
        for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
            <li class="ct-product-heading ct-tab ct-product-<?php echo esc_attr($i); ?>"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></li>
        <?php } ?>
    </ul>
    <table>
        <tbody>
            <!-- Header -->
            <tr class="ct-header">
                <!-- Title. -->
                <td class="ct-features-heading">
                    <h2 class="ct-title"><?php echo esc_html($settings['ct_feature_heading']); ?></h2>
                    <svg width="270" height="240" viewBox="0 0 270 240" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_17_251)">
                            <path d="M135 200C245.457 200 335 110.457 335 0C335 -110.457 245.457 -200 135 -200C24.5431 -200 -65 -110.457 -65 0C-65 110.457 24.5431 200 135 200Z" fill="#F49030"/>
                            <path d="M40 198C51.0457 198 60 189.046 60 178C60 166.954 51.0457 158 40 158C28.9543 158 20 166.954 20 178C20 189.046 28.9543 198 40 198Z" fill="white"/>
                            <path d="M40 194C48.8366 194 56 186.837 56 178C56 169.163 48.8366 162 40 162C31.1634 162 24 169.163 24 178C24 186.837 31.1634 194 40 194Z" fill="#F49030"/>
                            <path d="M230 198C241.046 198 250 189.046 250 178C250 166.954 241.046 158 230 158C218.954 158 210 166.954 210 178C210 189.046 218.954 198 230 198Z" fill="white"/>
                            <path d="M230 194C238.837 194 246 186.837 246 178C246 169.163 238.837 162 230 162C221.163 162 214 169.163 214 178C214 186.837 221.163 194 230 194Z" fill="#F49030"/>
                            <path d="M64 216C68.4183 216 72 212.418 72 208C72 203.582 68.4183 200 64 200C59.5817 200 56 203.582 56 208C56 212.418 59.5817 216 64 216Z" fill="#F49030"/>
                            <path opacity="0.5" d="M40 215C42.7614 215 45 212.761 45 210C45 207.239 42.7614 205 40 205C37.2386 205 35 207.239 35 210C35 212.761 37.2386 215 40 215Z" fill="#F49030"/>
                            <path opacity="0.5" d="M230 215C232.761 215 235 212.761 235 210C235 207.239 232.761 205 230 205C227.239 205 225 207.239 225 210C225 212.761 227.239 215 230 215Z" fill="#F49030"/>
                            <path opacity="0.15" d="M0 80C44.1828 80 80 44.1828 80 0C80 -44.1828 44.1828 -80 0 -80C-44.1828 -80 -80 -44.1828 -80 0C-80 44.1828 -44.1828 80 0 80Z" fill="white"/>
                            <path d="M206 216C210.418 216 214 212.418 214 208C214 203.582 210.418 200 206 200C201.582 200 198 203.582 198 208C198 212.418 201.582 216 206 216Z" fill="#F49030"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_17_251">
                                <rect width="270" height="240" fill="white"/>
                            </clipPath>
                        </defs>
                    </svg>
                </td>
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>">
                    <!-- Image -->
                        <?php if (!empty($settings['ct_product_image_' . $i]['url'])) { ?>
                            <img class="ct-product-img" src="<?php echo esc_url($settings['ct_product_image_' . $i]['url']); ?>" />
                        <?php } ?>
                        <svg width="270" height="240" viewBox="0 0 270 240" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_17_251)">
                                <path d="M135 200C245.457 200 335 110.457 335 0C335 -110.457 245.457 -200 135 -200C24.5431 -200 -65 -110.457 -65 0C-65 110.457 24.5431 200 135 200Z" fill="#F49030"/>
                                <path d="M40 198C51.0457 198 60 189.046 60 178C60 166.954 51.0457 158 40 158C28.9543 158 20 166.954 20 178C20 189.046 28.9543 198 40 198Z" fill="white"/>
                                <path d="M40 194C48.8366 194 56 186.837 56 178C56 169.163 48.8366 162 40 162C31.1634 162 24 169.163 24 178C24 186.837 31.1634 194 40 194Z" fill="#F49030"/>
                                <path d="M230 198C241.046 198 250 189.046 250 178C250 166.954 241.046 158 230 158C218.954 158 210 166.954 210 178C210 189.046 218.954 198 230 198Z" fill="white"/>
                                <path d="M230 194C238.837 194 246 186.837 246 178C246 169.163 238.837 162 230 162C221.163 162 214 169.163 214 178C214 186.837 221.163 194 230 194Z" fill="#F49030"/>
                                <path d="M64 216C68.4183 216 72 212.418 72 208C72 203.582 68.4183 200 64 200C59.5817 200 56 203.582 56 208C56 212.418 59.5817 216 64 216Z" fill="#F49030"/>
                                <path opacity="0.5" d="M40 215C42.7614 215 45 212.761 45 210C45 207.239 42.7614 205 40 205C37.2386 205 35 207.239 35 210C35 212.761 37.2386 215 40 215Z" fill="#F49030"/>
                                <path opacity="0.5" d="M230 215C232.761 215 235 212.761 235 210C235 207.239 232.761 205 230 205C227.239 205 225 207.239 225 210C225 212.761 227.239 215 230 215Z" fill="#F49030"/>
                                <path opacity="0.15" d="M0 80C44.1828 80 80 44.1828 80 0C80 -44.1828 44.1828 -80 0 -80C-44.1828 -80 -80 -44.1828 -80 0C-80 44.1828 -44.1828 80 0 80Z" fill="white"/>
                                <path d="M206 216C210.418 216 214 212.418 214 208C214 203.582 210.418 200 206 200C201.582 200 198 203.582 198 208C198 212.418 201.582 216 206 216Z" fill="#F49030"/>
                            </g>
                            <defs>
                                <clipPath id="clip0_17_251">
                                    <rect width="270" height="240" fill="white"/>
                                </clipPath>
                            </defs>
                        </svg>
                        <?php
                        // Currency Symbol.
                        if ('ct_custom' !== $settings['ac_currency_symbol_' . $i]) {
                            $ct_price_symbol = ac_get_currency_symbol($settings['ac_currency_symbol_' . $i]);
                        } else {
                            $ct_price_symbol = $settings['ct_currency_text_symbol_' .$i];
                        } ?>
                        <!-- Price -->
                        <span class="ct-product-price"><?php echo esc_html($ct_price_symbol . $settings['ct_product_price_' . $i]); ?></span>
                    </td>
                <?php } ?>
            </tr>
            <?php
            // Features.
            $count = count( $settings['ct_feature_list'] );
            for ( $x = 1; $x <= $count; $x++ ) { ?>
                <tr>
                    <!-- Feature Title -->
                    <td class="ct-feature-heading"><?php echo esc_html($settings['ct_feature_list'][ $x - 1 ]['ct_feature']); ?></td>
                    <?php for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) { ?>
                        <td class="ct-feature ct-product-<?php echo esc_attr($j); ?>">
                        <!-- Feature Content -->
                            <?php
                            if ( count( $settings[ 'ct_feature_list_' . $j ] ) >= $x ) {
                                if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'text' && $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'icon') {
                                    if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'fa fa-close' ) { ?>
                                        <i class="ct-mark-no <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    } else { ?>
                                        <i class="ct-mark-yes <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    }
                                } elseif ($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'icon') {
                                    ?><i class="<?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_icon']['value']);?>"></i><?php
                                } else {
                                    echo esc_html($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_text']);
                                }
                            } else {
                                echo '';
                            } ?>
                        </td>
                    <?php } ?>
                </tr>
            <?php } ?>
            <!-- Button -->
            <tr>
                <?php if($settings['ct_feature_heading_button'] != ""){ ?>
                    <!-- Button Title -->
                    <td class="ct-feature-heading ct-feature-heading-button"><?php echo esc_html($settings['ct_feature_heading_button']); ?></td>
                <?php } else { ?>
                    <td class="ct-blank-heading"></td>
                <?php }
                // Button.
                for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) {
                    $button_link    = $settings['ct_product_link_' . $j]['url'];
                    $target         = $settings['ct_product_link_' . $j]['is_external'] ? ' target="_blank"' : '';
                    $rel            = $settings['ct_product_link_' . $j]['nofollow'] ? ' rel="nofollow"' : ''; ?>
                    <td class="ct-feature-button ct-product-<?php echo esc_attr($j); ?>">
                        <?php if ( $settings[ 'ct_button_text_' . $j ] !== '' ) { ?>
                            <a class="ct-product-btn" href="<?php echo esc_url($button_link); ?>"<?php echo esc_attr($target); echo esc_attr($rel);?>><?php echo esc_html($settings['ct_button_text_' . $j]); ?></a>
                        <?php } ?>
                    </td>
                    <?php
                } ?>
            </tr>
        </tbody>
    </table>
</div>
<!-- End Advanced Comparison Table Style 5 -->