<!-- Start Advanced Comparison Table Style 6 -->
<div class="acte ct-style-6">
    <ul><?php
    // Tab Title.
        for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
            <li class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></li>
        <?php } ?>
    </ul>
    <table>
        <tbody>
            <!-- Header -->
            <tr class="ct-header">
                <td class="ct-features-heading" >
                    <h2 class="ct-title"><?php echo esc_html($settings['ct_feature_heading']); ?></h2>
                </td>
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>">
                        <?php
                        // Image.
                        if (!empty($settings['ct_product_image_' . $i]['url'])) { ?>
                            <div class="ct-product-image">
                                <img class="ct-product-img" src="<?php echo esc_url($settings['ct_product_image_' . $i]['url']); ?>" />
                            </div>
                        <?php }
                        // Title.
                        if (!empty($settings['ct_product_title_' . $i])) { ?>
                            <div class="ct-title-wrapper">
                                <?php if (!empty($settings['ct_product_title_' . $i])) { ?>
                                    <div class="ct-product-title"><?php echo esc_html($settings['ct_product_title_' . $i]); ?></div>
                                <?php } ?>
                            </div>
                            <?php
                        }
                        // Price.
                        if (!empty($settings['ct_product_price_' . $i])) { 
                            if ('ct_custom' !== $settings['ac_currency_symbol_' . $i]) {
                            // Currency Symbol.
                                $ct_price_symbol = ac_get_currency_symbol($settings['ac_currency_symbol_' . $i]);
                            } else {
                                $ct_price_symbol = $settings['ct_currency_text_symbol_' .$i];
                            } ?>
                            <!-- Price -->
                            <div class="ct-feature ct-product-price"><span><?php echo esc_html($ct_price_symbol . $settings['ct_product_price_' . $i]); ?></span></div>
                            <?php
                        } ?>
                    </td>
                <?php } ?>
            </tr>
            <!-- Features -->
            <tr>
                <td><div class="ct-features-box"></div></td>
                <?php for ( $i = 1; $i <= $settings['ct_product_count']; $i++ ) { ?>
                    <td class="ct-product-heading ct-product-<?php echo esc_attr($i); ?>"><div class="ct-features-box"></div></td>
                <?php } ?>
            </tr>
            <?php
            $count = count( $settings['ct_feature_list'] );
            for ( $x = 1; $x <= $count; $x++ ) { ?>
                <tr>
                    <!-- Feature Title -->
                    <td class="ct-feature-heading"><div class="ct-feature-title"><?php echo esc_html($settings['ct_feature_list'][ $x - 1 ]['ct_feature']); ?></div></td>
                    <?php for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) { ?>
                        <td class="ct-feature ct-product-<?php echo esc_attr($j); ?>">
                        <!-- Feature Content -->
                            <?php
                            if ( count( $settings[ 'ct_feature_list_' . $j ] ) >= $x ) {
                                if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'text' && $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] !== 'icon') {
                                    if ( $settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'fa fa-close' ) { ?>
                                        <i class="ct-mark-no <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    } else { ?>
                                        <i class="ct-mark-yes <?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type']); ?>"></i><?php
                                    }
                                } elseif ($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_content_type'] === 'icon') {
                                    ?><i class="<?php echo esc_attr($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_icon']['value']);?>"></i><?php
                                } else {
                                    echo esc_html($settings[ 'ct_feature_list_' . $j ][ $x - 1 ]['ct_feature_text']);
                                }
                            } else {
                                echo '';
                            } ?>
                        </td>
                    <?php } ?>
                </tr>
            <?php } ?>
            <!-- Button -->
            <tr>
                <?php if($settings['ct_feature_heading_button'] != ""){ ?>
                    <!-- Button Title -->
                    <td class="ct-feature-heading ct-feature-heading-button"><div class="ct-feature-title"><?php echo esc_html($settings['ct_feature_heading_button']); ?></div></td>
                <?php } else { ?>
                    <td class="ct-blank-heading"></td>
                <?php }
                // Button.
                for ( $j = 1; $j <= $settings['ct_product_count']; $j++ ) {
                    $button_link    = $settings['ct_product_link_' . $j]['url'];
                    $target         = $settings['ct_product_link_' . $j]['is_external'] ? ' target="_blank"' : '';
                    $rel            = $settings['ct_product_link_' . $j]['nofollow'] ? ' rel="nofollow"' : ''; ?>
                    <td class="ct-feature-button ct-product-<?php echo esc_attr($j); ?>">
                        <?php if ( $settings[ 'ct_button_text_' . $j ] !== '' ) { ?>
                            <a class="ct-product-btn" href="<?php echo esc_url($button_link); ?>" <?php echo esc_attr($target); echo esc_attr($rel);?>><?php echo esc_html($settings['ct_button_text_' . $j]); ?></a>
                        <?php } ?>
                    </td>
                <?php } ?>
            </tr>
        </tbody>
    </table>
</div>
<!-- End Advanced Comparison Table Style 6 -->