<?php
/**
 * Return Currency Symbol.
 * 
 * @access public
 * @since  1.0
 */
if (!function_exists('ac_get_currency_symbol')) {
    function ac_get_currency_symbol( $ct_symbol_name ) {
        $ct_symbols = [
            'dollar'        => '&#36;',
            'euro'          => '&#128;',
            'franc'         => '&#8355;',
            'pound'         => '&#163;',
            'ruble'         => '&#8381;',
            'shekel'        => '&#8362;',
            'baht'          => '&#3647;',
            'yen'           => '&#165;',
            'won'           => '&#8361;',
            'guilder'       => '&fnof;',
            'peso'          => '&#8369;',
            'peseta'        => '&#8359',
            'lira'          => '&#8356;',
            'rupee'         => '&#8360;',
            'indian_rupee'  => '&#8377;',
            'real'          => 'R$',
            'krona'         => 'kr',
        ];
        return isset( $ct_symbols[ $ct_symbol_name ] ) ? $ct_symbols[ $ct_symbol_name ] : '';
    }
}