<?php
namespace Elementor;

/**
 * If this file is called directly, abort.
 */
if (!defined('ABSPATH')) {
    exit;   
}

/**
 * Class Comparison Table
 */
class ACTE_Widget extends Widget_Base {

    // Function for get the slug of the element name.
    public function get_name() {
        return 'advanced-comparison-table';
    }

    // Function for get the name of the element.
    public function get_title() {
        return esc_html__('Advanced Comparison Table', 'advanced-comparison-table-for-elementor');
    }

    // Function for get the icon of the element.
    public function get_icon() {
        return 'eicon-table-of-contents';
    }

    // Function for include element into the category.
    public function get_categories() {
        return ['advanced-comparison-table'];
    }

    // Function for include element keywords.
    public function get_keywords() {
        return ['comparison table', 'acte', 'comparison table'];
	}

    // Function for include css
    public function get_style_depends()
    {
        return ['acte-style'];
    }

	// Function for include js
	public function get_script_depends()
    {
        return ['acte-script'];
    }

    // Adding the controls fields for the Comparison Table Element
    protected function register_controls() {

		// Start Content Tab.
        // Start General Section
        $this->start_controls_section(
            'ct_section_general', array(
                'label'         => esc_html__('General', 'advanced-comparison-table-for-elementor'),
            )
        );

		// Layout.
        $this->add_control(
            'ct_skin', [
                'label'         	=> esc_html__('Layouts', 'advanced-comparison-table-for-elementor'),
                'type'          	=> Controls_Manager::SELECT,
                'options'       	=> [
                    'style-1' 		=> esc_html__('Design 1', 'advanced-comparison-table-for-elementor'),
                    'style-2' 		=> esc_html__('Design 2', 'advanced-comparison-table-for-elementor'),
                    'style-3' 		=> esc_html__('Design 3', 'advanced-comparison-table-for-elementor'),
					'style-4' 		=> esc_html__('Design 4', 'advanced-comparison-table-for-elementor'),
					'style-5' 		=> esc_html__('Design 5', 'advanced-comparison-table-for-elementor'),
					'style-6' 		=> esc_html__('Design 6', 'advanced-comparison-table-for-elementor'),
					'style-7' 		=> esc_html__('Design 7', 'advanced-comparison-table-for-elementor'),
					'style-8' 		=> esc_html__('Design 8', 'advanced-comparison-table-for-elementor'),
                ],
                'default'       	=> 'style-1',
            ]
        );

		// Products.
		$this->add_control(
			'ct_product_count',
			[
				'label'         	=> esc_html__('Products', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::NUMBER,
				'default'       	=> 3,
				'min'           	=> 2,
				'max'           	=> 6,
			]
		);

		$this->end_controls_section();
        // End General Section

        // Start Features Section
        $this->start_controls_section(
            'ct_section_feature', array(
                'label'         	=> esc_html__('Features Box', 'advanced-comparison-table-for-elementor'),
            )
        );

		// Heading for Product.
		$this->add_control(
			'ct_feature_heading', [
				'label'         	=> esc_html__('Heading', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::TEXT,
				'default'       	=> esc_html__('Product', 'advanced-comparison-table-for-elementor'),
			]
		);

		// Start Feature Repeater Field.
        $repeater = new Repeater();

		// Feature Heading.
		$repeater->add_control(
			'ct_feature', [
                'label'         	=> esc_html__('Feature', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::TEXT,
				'default'       	=> esc_html__('Feature', 'advanced-comparison-table-for-elementor'),
			]
		);

		// Feature Title.
        $this->add_control(
			'ct_feature_list', [
				'label'         	=> esc_html__('Features', 'advanced-comparison-table-for-elementor'),
                'type'          	=> Controls_Manager::REPEATER,
                'fields'        	=> $repeater->get_controls(),
                'render_type'   	=> 'template',
                'default'       	=> [
                    [
                        'ct_feature' => esc_html__('Title', 'advanced-comparison-table-for-elementor'),
                    ],
                    [
                        'ct_feature' => esc_html__('Size', 'advanced-comparison-table-for-elementor'),
                    ],
                    [
                        'ct_feature' => esc_html__('Warranty', 'advanced-comparison-table-for-elementor'),
                    ],
                    [
                        'ct_feature' => esc_html__('Availability', 'advanced-comparison-table-for-elementor'),
                    ],
                ],
			]
        );

		// Button Heading for Feature.
        $this->add_control(
			'ct_feature_heading_button', [
				'label'         	=> esc_html__('Button Heading', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::TEXT,
			]
		);

        $this->end_controls_section();
        // End Features Section

        $this->add_product();
		// End Feature Repeater Field.

    }

    // Function for adding product sections
    public function add_product() {

        $repeater = new Repeater();

		// Start Content Repeater Field.
		$repeater->add_control(
			'ct_content_type', [
				'label'         	=> esc_html__('Content', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::CHOOSE,
				'label_block'   	=> false,
				'options'       	=> [
					'fa fa-check' 	=> [
						'title' 	=> esc_html__('Yes', 'advanced-comparison-table-for-elementor'),
						'icon'  	=> 'fa fa-check',
					],
					'fa fa-close' 	=> [
						'title' 	=> esc_html__('No', 'advanced-comparison-table-for-elementor'),
						'icon'  	=> 'eicon-close',
					],
                    'icon' 			=> [
						'title' 	=> esc_html__('Icon', 'advanced-comparison-table-for-elementor'),
						'icon'  	=> 'fa fa-info',
					],
					'text' 			=> [
						'title' 	=> esc_html__('Text', 'advanced-comparison-table-for-elementor'),
						'icon'  	=> 'fa fa-font',
					],
				],
				'default'       	=> 'text',
			]
		);

		// Feature Content Text.
		$repeater->add_control(
			'ct_feature_text', [
				'label'         	=> esc_html__('Feature', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::TEXT,
				'default'       	=> esc_html__('Feature', 'advanced-comparison-table-for-elementor'),
				'condition'     	=> [
					'ct_content_type' => 'text',
				],
			]
		);

		// Content Icon.
        $repeater->add_control(
			'ct_feature_icon', [
				'label'         	=> esc_html__('Icon', 'advanced-comparison-table-for-elementor'),
				'type'          	=> Controls_Manager::ICONS,
                'default'       	=> [
                    'value'     	=> 'fa fa-shopping-bag',
                    'library'   	=> 'fa-solid',
                ],
				'condition'     	=> [
					'ct_content_type' => 'icon',
				],
			]
		);

        for ( $i = 1; $i <7; $i++ ) {

			// Product Section.
            $this->start_controls_section(
				'ct_product_section_' . $i, [
					// Translators: %s stands for the product index number
					'label'     	=> sprintf( esc_html__('Product %s', 'advanced-comparison-table-for-elementor'), $i ),
					'operator'  	=> '>',
					'condition' 	=> [
						'ct_product_count' => $this->add_condition_value( $i ),
					],
				]
			);

			// Title Text.
			$this->add_control(
				'ct_product_title_' . $i, [
					'label'     	=> esc_html__('Title', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::TEXT,
					'default'   	=> esc_html__('Title', 'advanced-comparison-table-for-elementor'),
				]
			);

			//Custom Currency Symbol.
			$this->add_control(
				'ac_currency_symbol_' . $i, [
					'label'             => esc_html__('Currency Symbol', 'advanced-comparison-table-for-elementor'),
					'type'              => Controls_Manager::SELECT,
					'options'           => [
						''              => esc_html__('None', 'advanced-comparison-table-for-elementor' ),
						'dollar'        => '&#36; ' . _x('Dollar', 'Currency', 'advanced-comparison-table-for-elementor'),
						'euro'          => '&#128; ' . _x('Euro', 'Currency', 'advanced-comparison-table-for-elementor'),
						'baht'          => '&#3647; ' . _x('Baht', 'Currency', 'advanced-comparison-table-for-elementor'),
						'franc'         => '&#8355; ' . _x('Franc', 'Currency', 'advanced-comparison-table-for-elementor'),
						'guilder'       => '&fnof; ' . _x('Guilder', 'Currency', 'advanced-comparison-table-for-elementor'),
						'krona'         => 'kr ' . _x('Krona', 'Currency', 'advanced-comparison-table-for-elementor'),
						'lira'          => '&#8356; ' . _x('Lira', 'Currency', 'advanced-comparison-table-for-elementor'),
						'peso'          => '&#8369; ' . _x('Peso', 'Currency', 'advanced-comparison-table-for-elementor'),
						'pound'         => '&#163; ' . _x('Pound Sterling', 'Currency', 'advanced-comparison-table-for-elementor'),
						'real'          => 'R$ ' . _x('Real', 'Currency', 'advanced-comparison-table-for-elementor'),
						'ruble'         => '&#8381; ' . _x('Ruble', 'Currency', 'advanced-comparison-table-for-elementor'),
						'rupee'         => '&#8360; ' . _x('Rupee', 'Currency', 'advanced-comparison-table-for-elementor'),
						'indian_rupee'  => '&#8377; ' . _x('Rupee (Indian)', 'Currency', 'advanced-comparison-table-for-elementor'),
						'shekel'        => '&#8362; ' . _x('Shekel', 'Currency', 'advanced-comparison-table-for-elementor'),
						'yen'           => '&#165; ' . _x('Yen/Yuan', 'Currency', 'advanced-comparison-table-for-elementor'),
						'won'           => '&#8361; ' . _x('Won', 'Currency', 'advanced-comparison-table-for-elementor'),
						'ct_custom' 	=> esc_html__('Custom', 'advanced-comparison-table-for-elementor'),
					],
					'default'           => '',
				]
			);

			//Custom Currency Text.
			$this->add_control(
				'ct_currency_text_symbol_'. $i, [
					'label'             => esc_html__('Custom Symbol', 'advanced-comparison-table-for-elementor'),
					'type'              => Controls_Manager::TEXT,
					'condition'         => [
						'ac_currency_symbol_' . $i => 'ct_custom',
					],
				]
			);

			// Price.
			$this->add_control(
				'ct_product_price_' . $i, [
					'label'    		=> esc_html__('Price', 'advanced-comparison-table-for-elementor'),
					'type'     		=> Controls_Manager::TEXT,
					'default'  		=> esc_html__('$199', 'advanced-comparison-table-for-elementor'),
				]
			);

			// Image.
			$this->add_control(
				'ct_product_image_' . $i, [
					'label'     	=> esc_html__('Image', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::MEDIA,
					'default'       => [
						'url'       => ACTE_URL . 'assets/image/shoe-placeholder.png',
					],
				]
			);

			// Button Text.
			$this->add_control(
				'ct_button_text_' . $i, [
					'label'     	=> esc_html__('Button Text', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::TEXT,
					'default'   	=> esc_html__('Buy Now', 'advanced-comparison-table-for-elementor'),
				]
			);

			// Button Link.
			$this->add_control(
				'ct_product_link_' . $i, [
					'label'     	=> esc_html__('Link', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::URL,
					'placeholder' 	=> esc_html__( 'https://your-link.com', 'advanced-comparison-table-for-elementor' ),
					'default'		=> [
						'url'		=> '',
						'is_external' => true,
						'nofollow' 	=> true,
					],
					'label_block' 	=> true,
				]
			);

			// Features for Default.
            $this->add_control(
                'ct_feature_list_' .$i, [
                    'label'         => esc_html__('Features', 'advanced-comparison-table-for-elementor'),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeater->get_controls(),
                    'render_type'   => 'template',
                    'default'       => [
                        [
                            'ct_feature_text' => esc_html__('Shoes', 'advanced-comparison-table-for-elementor'),
                        ],
                        [
                            'ct_feature_text' => esc_html__('All', 'advanced-comparison-table-for-elementor'),
                        ],
                        [
                            'ct_feature_text' => esc_html__('1 Year', 'advanced-comparison-table-for-elementor'),
                        ],
                        [
                            'ct_feature_text' => esc_html__('In Stock', 'advanced-comparison-table-for-elementor'),
                        ],
                    ],
                ]
            );

			// Switcher for Override Style.
			$this->add_control(
				'ct_override_style_' . $i, [
					'label'        => esc_html__('Override Style', 'advanced-comparison-table-for-elementor'),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'no',
					'separator'    => 'before',
				]
			);

			// Title for Heading.
			$this->add_control(
				'ct_custom_heading_' . $i, [
					'label'     	=> esc_html__('Heading', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::HEADING,
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Color for Heading.
			$this->add_control(
				'ct_heading_custom_color_' . $i, [
					'label'     	=> esc_html__('Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-product-heading.ct-product-' . $i . ' .ct-product-title'=> 'color: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Background Color for Heading.
			$this->add_control(
				'ct_heading_bg_custom_color_' . $i, [
					'label'     	=> esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .acte.ct-style-1 .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-3 .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-4 .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-2 .ct-product-heading.ct-product-'.$i.' .ct-product-title' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-2 .ct-product-heading.ct-product-'.$i.' .ct-product-title:after' => 'border-left-color: {{VALUE}}; border-right-color: {{VALUE}};',
						'{{WRAPPER}} .ct-product-heading.ct-product-' . $i . ' .ct-inner' => 'fill: {{VALUE}};',
						'{{WRAPPER}} .acte.ct-style-4 .ct-product-' . $i . ' .ct-product-price path' => 'fill: {{VALUE}};',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(1)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(3)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(5)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(6)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(7)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(8)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(9)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i .' svg path:nth-child(10)' => 'fill: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-product-' . $i . ' .ct-product-price'=> 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-6 tr:first-child .ct-product-heading.ct-product-' . $i . ' .ct-product-image' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-6 tr:first-child .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-7 tr:nth-child(2) .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-product-heading.ct-product-' . $i . ' .ct-product-image'=> 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-heading.ct-tab.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-6 .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-7 .ct-product-heading.ct-tab.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-8 .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Column Background Color.
			$this->add_control(
				'ct_heading_bg_custom_column_color_' . $i, [
					'label'     	=> esc_html__('Column Background Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-product-heading.ct-product-' . $i . ' .ct-rect' => 'fill: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin' 	=> 'style-4',
					],
				]
			);

			// Border Color.
			$this->add_control(
				'ct_heading_bg_custom_border_color_' . $i, [
					'label'     	=> esc_html__('Border Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-product-heading.ct-product-' . $i . ' .ct-border' => 'fill: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin' 	=> 'style-4',
					],
				]
			);

			// Price Heading.
			$this->add_control(
				'ct_custom_price_' . $i, [
					'label'     	=> esc_html__('Price', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::HEADING,
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
					'separator'    => 'before',
				]
			);

			// Price Color.
			$this->add_control(
				'ct_price_custom_color_' . $i, [
					'label'     	=> esc_html__('Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .acte.ct-style-1 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-2 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-3 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-4 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-6 .ct-product-' . $i . ' .ct-product-price span' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-7 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-8 .ct-product-' . $i . ' .ct-product-price' => 'color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Price Background Color.
			$this->add_control(
				'ct_price_bg_custom_color_' . $i, [
					'label'     	=> esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-feature.ct-product-price.ct-product-' . $i . ' .ct-price' => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .ct-style-3 .ct-feature.ct-product-price.ct-product-' . $i => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .acte.ct-style-6 .ct-product-' . $i . ' .ct-product-price span' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-7 tr:first-child .ct-product-heading.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin' 	=> ['style-2', 'style-6', 'style-7'],
					],
				]
			);

			// Background Column Color.
			$this->add_control(
				'ct_price_bg_column_custom_color_' . $i, [
					'label'     	=> esc_html__('Background Column Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-feature.ct-product-price.ct-product-' . $i => 'background-color: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin' 	=> 'style-2',
					],
				]
			);

			// Feature Heading.
			$this->add_control(
				'ct_custom_feature_' . $i, [
					'label'     	=> esc_html__('Features', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::HEADING,
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
					'separator'    	=> 'before',
				]
			);

			// Color for Icon & Text.
			$this->add_control(
				'ct_features_custom_color_' . $i, [
					'label'     	=> esc_html__('Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-feature.ct-product-' . $i => 'color: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Check Color
			$this->add_control(
				'ct_features_tbl_check_color_' . $i, [
					'label'     	=> esc_html__('Check Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-feature.ct-product-' . $i . ' i.fa.fa-check' => 'color: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Close Color.
			$this->add_control(
				'ct_features_tbl_close_color_' . $i, [
					'label'     	=> esc_html__('Close Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-feature.ct-product-' . $i . ' i.fa.fa-close' => 'color: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Odd Row Color.
			$this->add_control(
				'ct_odd_row_custom_color_' . $i, [
					'label'     	=> esc_html__('Odd Row Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} tr:nth-child(even) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Even Row Color.
			$this->add_control(
				'ct_even_row_custom_color_' . $i, [
					'label'     	=> esc_html__('Even Row Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .acte.ct-style-1 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-2 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-3 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-4 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-5 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}};',
						'{{WRAPPER}} .acte.ct-style-6 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-8 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .acte.ct-style-2 .ct-product-heading.ct-product-'.$i.' .ct-product-title:after' => 'border-top-color: {{VALUE}};',
						'{{WRAPPER}} .acte.ct-style-7 tr:nth-child(odd) td.ct-product-' . $i => 'background-color: {{VALUE}} ;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);
			

			// Button Heading.
			$this->add_control(
				'ct_custom_button_heading_' . $i, [
					'label'     	=> esc_html__('Button', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::HEADING,
					'separator' 	=> 'before',
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Button Text Color.
			$this->add_control(
				'ct_custom_button_text_color_' . $i, [
					'label'     	=> esc_html__('Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-product-' . $i . ' .ct-product-btn' => 'color: {{VALUE}};',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Button Background Color.
			$this->add_control(
				'ct_custom_button_bg_color_' . $i, [
					'label'     	=> esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-style-1 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-2 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-4 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-5 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-6 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-7 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-8 .ct-product-' . $i . ' .ct-product-btn' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-3 .ct-feature-button.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Border Color.
			$this->add_control(
				'ct_btn_border_color_or_' . $i, [
					'label'         => esc_html__('Border Color', 'advanced-comparison-table-for-elementor'),
					'type'          => Controls_Manager::COLOR,
					'selectors'     => [
						'{{WRAPPER}} .ct-style-1 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-2 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-4 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-5 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-6 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-7 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-8 .ct-product-' . $i . ' .ct-product-btn' => 'border-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin!' 	=> 'style-3',
					],
				]
			);

			// Button Text Hover Color.
			$this->add_control(
				'ct_custom_button_text_hover_color_' . $i, [
					'label'     	=> esc_html__('Hover Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-style-1 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-2 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-4 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-5 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-6 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-7 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-8 .ct-product-' . $i . ' .ct-product-btn:hover' => 'color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-3 .ct-product-' . $i . '.ct-feature-button:hover .ct-product-btn' => 'color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Button Background Hover Color.
			$this->add_control(
				'ct_custom_button_bg_hover_color_' . $i, [
					'label'     	=> esc_html__('Hover Background Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-style-1 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-2 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-4 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-5 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-6 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-7 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-8 .ct-product-' . $i . ' .ct-product-btn:hover' => 'background-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-3 .ct-product-' . $i . '.ct-feature-button:hover' => 'background-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
					],
				]
			);

			// Border Color.
			$this->add_control(
				'ct_btn_border_color_or__hover' . $i, [
					'label'         => esc_html__('Border Color', 'advanced-comparison-table-for-elementor'),
					'type'          => Controls_Manager::COLOR,
					'selectors'     => [
						'{{WRAPPER}} .ct-style-1 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-2 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-4 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-5 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-6 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-7 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
						'{{WRAPPER}} .ct-style-8 .ct-product-' . $i . ' .ct-product-btn:hover' => 'border-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin!' 	=> 'style-3',
					],
				]
			);

			// Column Background Color.
			$this->add_control(
				'ct_custom_btn_clm_background_color_' . $i, [
					'label'     	=> esc_html__('Column Background Color', 'advanced-comparison-table-for-elementor'),
					'type'      	=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .ct-feature-button.ct-product-' . $i => 'background-color: {{VALUE}} !important;',
					],
					'condition' 	=> [
						'ct_override_style_' . $i => 'yes',
						'ct_skin!' 	=> ['style-3', 'style-5', 'style-7', 'style-8'],
					],
				]
			);

            $this->end_controls_section();
			// End Product Section.
        }
		// End Content Tab.

        // Start General Style Tab.
        $this->start_controls_section(
			'section_general_style', [
				'label'         => esc_html__('General', 'advanced-comparison-table-for-elementor'),
				'tab'           => Controls_Manager::TAB_STYLE,
			]
		);

		// Odd Row Color.
		$this->add_control(
			'ct_even_color', [
				'label'         => esc_html__('Odd Row Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-2 .ct-product-title:after' => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-4 .ct-product-price path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-1 tr:nth-child(odd) td,
					{{WRAPPER}} .acte.ct-style-2 tr:nth-child(odd) td,
					{{WRAPPER}} .acte.ct-style-3 tr:nth-child(odd) td,
					{{WRAPPER}} .acte.ct-style-4 tr:nth-child(odd) td,
					{{WRAPPER}} .acte.ct-style-5 tr:nth-child(odd) td,
					{{WRAPPER}} .acte.ct-style-6 tr:nth-child(odd) td,
					{{WRAPPER}} .acte.ct-style-7 tr:nth-child(even) td:nth-child(odd),
					{{WRAPPER}} .acte.ct-style-7 tr:nth-child(odd) td:nth-child(even),
					{{WRAPPER}} .acte.ct-style-8 tr:nth-child(odd) td,
					{{WRAPPER}} tr:nth-child(even) td.ct-product-' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Even Row Color.
        $this->add_control(
			'ct_odd_color', [
				'label'         => esc_html__('Even Row Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 tr:nth-child(even) td,
					{{WRAPPER}} .acte.ct-style-2 tr:nth-child(even) td,
					{{WRAPPER}} .acte.ct-style-3 tr:nth-child(even) td,
					{{WRAPPER}} .acte.ct-style-4 tr:nth-child(even) td,
					{{WRAPPER}} .acte.ct-style-5 tr:nth-child(even) td,
					{{WRAPPER}} .acte.ct-style-6 tr:nth-child(even) td,
					{{WRAPPER}} .acte.ct-style-6 tr:nth-child(even) td .ct-features-box ,
					{{WRAPPER}} .acte.ct-style-7 tr:nth-child(even) td:nth-child(even),
					{{WRAPPER}} .acte.ct-style-7 tr:nth-child(odd) td:nth-child(odd),
					{{WRAPPER}} .acte.ct-style-8 tr:nth-child(even) td' => 'background-color: {{VALUE}};',
				],
			]
		);

		// Table Border.
        $this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'          => 'table_border',
				'label'         => esc_html__('Border', 'advanced-comparison-table-for-elementor'),
				'selector'   	=> '{{WRAPPER}} .acte td',
				'label_block'   => true,
			]
		);

		// Box Radius.
		$this->add_control(
            'ct_box_radius_spacing', [
                'label'         => esc_html__('Box Radius', 'advanced-comparison-table-for-elementor'),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [
                    'px'        => [
                        'min'   => 0,
                        'max'   => 100,
                    ],
                ],
                'selectors'     => [
                    '{{WRAPPER}} .acte.ct-style-2 td.ct-features-heading,
					{{WRAPPER}} .acte.ct-style-2 .ct-header .ct-price,
					{{WRAPPER}} .acte.ct-style-4 .ct-header td' => 'border-top-left-radius: {{SIZE}}{{UNIT}}; border-top-right-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-2 td.ct-feature-button,
					{{WRAPPER}} .acte.ct-style-4 td.ct-feature-button,
					{{WRAPPER}} .acte.ct-style-4 td.ct-feature-heading-button' => 'border-bottom-left-radius: {{SIZE}}{{UNIT}}; border-bottom-right-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-3 td' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-5 td' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-8 tr:nth-child(even) .ct-feature-title,
					{{WRAPPER}} .acte.ct-style-8 tr:nth-child(odd) .ct-feature-title' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
				'condition' 	=> [
					'ct_skin!' 	=> ['style-1', 'style-6', 'style-7'],
				],
            ]
        );

		// Column Spacing.
		$this->add_control(
            'ct_box_column_spacing', [
                'label'         => esc_html__('Column Spacing', 'advanced-comparison-table-for-elementor'),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [
                    'px'        => [
                        'min'   => 0,
                        'max'   => 100,
                    ],
                ],
				'default'       => ['size'  => 15],
                'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 table' => 'border-spacing: {{SIZE}}{{UNIT}} 0px;',
                    '{{WRAPPER}} .acte.ct-style-2 table' => 'border-spacing: {{SIZE}}{{UNIT}} 0px;',
					'{{WRAPPER}} .acte.ct-style-4 table' => 'border-spacing: {{SIZE}}{{UNIT}} 0px;',
					'{{WRAPPER}} .acte.ct-style-5 table' => 'border-spacing: {{SIZE}}{{UNIT}};',
                ],
				'condition' 	=> [
					'ct_skin' 	=> ['style-1', 'style-2', 'style-4', 'style-5'],
				],
            ]
        );

		// Row Spacing.
		$this->add_control(
            'ct_box_row_spacing', [
                'label'         => esc_html__('Row Spacing', 'advanced-comparison-table-for-elementor'),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [
                    'px'        => [
                        'min'   => 0,
                        'max'   => 100,
                    ],
                ],
				'default'       => ['size'  => 15],
				'condition' 	=> [
					'ct_skin' 	=> ['style-3'],
				],
            ]
        );

        $this->end_controls_section();
        // End General Style Tab.

        // Start Feature Box Style Tab.
        $this->start_controls_section(
			'section_feature_box_style', [
				'label'         => esc_html__('Feature Box', 'advanced-comparison-table-for-elementor'),
				'tab'           => Controls_Manager::TAB_STYLE,
			]
		);

		// Heading.
        $this->add_control(
			'ct_features_box_heading_style', [
				'label'         => esc_html__('Heading', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
			]
		);

		// Box Width.
		$this->add_responsive_control(
            'ct_headings_width', [
                'label'         => esc_html__('Box Width', 'advanced-comparison-table-for-elementor'),
                'type'          => Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px', '%' ],
				'range'         => [
                    'px'        => [
                        'min'   => 0,
                        'max'   => 500,
                    ],
                ],
				'mobile_default'       => ['size' => 50, 'unit' => '%'],
                'selectors'     => [
                    '{{WRAPPER}} .ct-features-heading' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		// Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      	=> 'ct_features_heading_typography',
				'selector'  	=> '{{WRAPPER}} .ct-features-heading,
				{{WRAPPER}} .ct-features-heading h2.ct-title',
			]
		);

		// Heading Color.
		$this->add_control(
			'ct_features_heading_color', [
				'label'         => esc_html__('Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#000',
				'selectors'     => [
					'{{WRAPPER}} .ct-features-heading,
					{{WRAPPER}} .ct-features-heading h2.ct-title' => 'color: {{VALUE}};',
				],
			]
		);

		// Heading Background Color.
		$this->add_control(
			'feature_heading_bg_color', [
				'label'         => esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#FFF3E2',
				'selectors'     => [
					'{{WRAPPER}} td.ct-features-heading' => 'background-color: {{VALUE}} !important;',
					'{{WRAPPER}} .ct-features-heading .ct-inner' => 'fill: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> ['style-1','style-2', 'style-3','style-4'],
				],
			]
		);

		// Column Background Color.
		$this->add_control(
			'feature_heading_bg_column_color', [
				'label'         => esc_html__('Column Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#ffffff',
				'selectors'     => [
					'{{WRAPPER}} .ct-features-heading .ct-rect' => 'fill: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-4',
				],
			]
		);

		// Border Color.
		$this->add_control(
			'feature_heading_bg_border_color', [
				'label'         => esc_html__('Border Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-features-heading .ct-border' => 'fill: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-4',
				],
			]
		);

		// Alignment of Heading.
        $this->add_responsive_control(
			'ct_features_text_align', [
				'label'     	=> esc_html__('Alignment', 'advanced-comparison-table-for-elementor'),
				'type'      	=> Controls_Manager::CHOOSE,
				'options'   	=> [
					'left' 		=> [
						'title' => esc_html__('Left', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__('Center', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__('Right', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   	=> 'center',
				'selectors' 	=> [
					'{{WRAPPER}} .ct-features-heading' => 'text-align: {{VALUE}};',
				],
			]
		);

		// Header Padding.
		$this->add_responsive_control(
			'ct_features_text_padding', [
				'label'         => esc_html__('Padding', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-features-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-5 .ct-features-heading h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin!' 	=> ['style-5'],
				],
			]
		);

		// Border Radius for Title.
		$this->add_control(
			'ct_title_radius', [
				'label'         => esc_html__('Title Border Radius', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::SLIDER,
				'range'         => [
					'px'        => [
						'min'   => 0,
						'max'   => 100,
					],
				],
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-features-heading, 
					{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-product-heading' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-features-heading, 
					{{WRAPPER}} .acte.ct-style-8 tr:nth-child(2) td' => 'border-top-left-radius: {{SIZE}}{{UNIT}}; border-top-right-radius:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .acte.ct-style-8 tr:nth-last-child(-n + 2) td' => 'border-bottom-left-radius: {{SIZE}}{{UNIT}}; border-bottom-right-radius:{{SIZE}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> ['style-8'],
				],
			]
		);

		// Feature Heading.
        $this->add_control(
			'ct_feature_box_heading_style', [
				'label'         => esc_html__('Feature', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
				'separator'     => 'before',
			]
		);

		// Feature Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'ct_feature_text_typography',
				'selector'      => '{{WRAPPER}} .ct-feature-heading',
			]
		);

		// Feature Color.
        $this->add_control(
			'ct_feature_text_color', [
				'label'         => esc_html__('Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-feature-heading' => 'color: {{VALUE}};',
				],
			]
		);

		// Odd Title Background Color.
		$this->add_control(
			'ct_feature_text_bg_color', [
				'label'         => esc_html__('Odd Title Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#f6b759',
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 tr:nth-child(odd) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-2 tr:nth-child(odd) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-3 tr:nth-child(odd) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-4 tr:nth-child(odd) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-5 tr:nth-child(odd) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-7 tr:nth-child(odd) .ct-feature-heading' => 'background-color: {{VALUE}} !important;',
					'{{WRAPPER}} .acte.ct-style-6 tr:nth-child(odd) .ct-feature-title,
					{{WRAPPER}} .acte.ct-style-8 tr:nth-child(odd) .ct-feature-title' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		// Even Title Background Color.
		$this->add_control(
			'ct_feature_even_color', [
				'label'         => esc_html__('Even Title Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#f6b759',
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 tr:nth-child(even) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-2 tr:nth-child(even) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-3 tr:nth-child(even) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-4 tr:nth-child(even) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-5 tr:nth-child(even) .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-7 tbody tr:nth-child(even) .ct-feature-heading' => 'background-color: {{VALUE}} !important;',
					'{{WRAPPER}} .acte.ct-style-6 tr:nth-child(even) .ct-feature-title,
					{{WRAPPER}} .acte.ct-style-8 tr:nth-child(even) .ct-feature-title' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		// Alignment of Title Text.
		$this->add_responsive_control(
			'ct_feature_text_align', [
				'label'         => esc_html__('Alignment', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::CHOOSE,
				'options'       => [
					'left' 		=> [
						'title' => esc_html__('Left', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__('Center', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__('Right', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'       => 'left',
				'selectors'     => [
					'{{WRAPPER}} .ct-feature-heading' => 'text-align: {{VALUE}};',
				],
			]
		);

		// Padding for Title.
		$this->add_responsive_control(
			'ct_feature_text_padding', [
				'label'         => esc_html__('Padding', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-2 .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-3 .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-4 .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-5 .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-6 .ct-feature-heading .ct-feature-title,
					{{WRAPPER}} .acte.ct-style-7 .ct-feature-heading,
					{{WRAPPER}} .acte.ct-style-8 .ct-feature-heading .ct-feature-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		// Border for Title.
		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'          => 'feature_border',
				'label'         => esc_html__('Border', 'advanced-comparison-table-for-elementor'),
				'fields_options'=> [
					'border'    => [
						'default' 	 => 'solid',
					],
					'width'     	 => [
						'default' 	 => [
							'top'    => 1,
							'right'  => 0,
							'bottom' => 1,
							'left'   => 0,
						],
					],
					'color'  		 => [
						'default' 	 => '#FFFFFF',
					],
				],
				'selector'   	=> '{{WRAPPER}} td.ct-feature-heading',
				'label_block'   => true,
				'condition' 	=> [
					'ct_skin'   => ['style-1','style-2']
				],
			]
		);

		// Border Radius for Title.
		$this->add_responsive_control(
			'ct_feature_box_radius	', [
				'label'         => esc_html__('Border Radius', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} td.ct-feature-heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-2'
				],
			]
		);

        $this->end_controls_section();
        // End Feature Box Style Tab.

        // Start Products Style Tab.
        $this->start_controls_section(
			'section_products_box_style', [
				'label'         => esc_html__('Products', 'advanced-comparison-table-for-elementor'),
				'tab'           => Controls_Manager::TAB_STYLE,
			]
		);

		// Heading.
        $this->add_control(
			'ct_product_box_heading_style', [
				'label'         => esc_html__('Tab Heading', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
			]
		);

		// Start Tab Format From.
		$this->add_control(
            'ct_tab_format', [
                'label'         => esc_html__('Start Tab Format From', 'advanced-comparison-table-for-elementor'),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [
                    'px'        => [
                        'min'   => 0,
                        'max'   => 1200,
                    ],
                ],
                'default'       => ['size'  => 767],
            ]
        );

		// Typography for Tab
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'ct_heading_text_typography',
				'label'         => esc_html__('Typography for Tab & Title', 'advanced-comparison-table-for-elementor'),
				'selector'      => '{{WRAPPER}} .ct-product-heading',
			]
		);

		// Text Color.
        $this->add_control(
			'ct_heading_text_color', [
				'label'         => esc_html__('Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#FFFFFF',
				'selectors'     => [
					'{{WRAPPER}} .ct-product-heading' => 'color: {{VALUE}};',
				],
			]
		);

		// Background Color
		$this->add_control(
			'ct_heading_text_bg_color', [
				'label'         => esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#F6B759',
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 tr:nth-child(odd) .ct-product-heading svg path,
					{{WRAPPER}} .ct-product-heading .ct-inner,
					{{WRAPPER}} .acte.ct-style-4 .ct-product-price path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-3 tr:nth-child(odd) .ct-product-heading,
					{{WRAPPER}} .acte.ct-style-2 .ct-product-title,
					{{WRAPPER}} .acte.ct-style-4 tr:nth-child(odd) .ct-product-heading,
					{{WRAPPER}} li.ct-product-heading,
					{{WRAPPER}} .acte.ct-style-5 .ct-product-price' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-2 .ct-product-title:after' => 'border-left-color: {{VALUE}}; border-right-color: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-5 .ct-features-heading svg path,
					{{WRAPPER}} .acte.ct-style-5 .ct-product-heading svg path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-6 tr:first-child .ct-features-heading,
					{{WRAPPER}} .acte.ct-style-6 tr:first-child .ct-product-heading,
					{{WRAPPER}} .acte.ct-style-6 .ct-product-image,
					{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-product-heading,
					{{WRAPPER}} .acte.ct-style-8 tr:first-child .ct-features-heading' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .acte.ct-style-7 tr:nth-child(2) .ct-features-heading' => 'background-color: {{VALUE}} !important;',
					'{{WRAPPER}} .acte.ct-style-8 .ct-product-image' => 'border-color: {{VALUE}};',
				],
			]
		);

		// Active Tab Text Color.
		$this->add_control(
			'ct_heading_active_text_color', [
				'label'         => esc_html__('Active Tab Text Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-product-heading.active' => 'color: {{VALUE}} !important;',
				],
			]
		);

		// Active Tab Background Color.
		$this->add_control(
			'ct_heading_active_text_bg_color', [
				'label'         => esc_html__('Active Tab Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-product-heading.active' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		// Column Background Color.
		$this->add_control(
			'feature_product_bg_column_color', [
				'label'         => esc_html__('Column Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#ffffff',
				'selectors'     => [
					'{{WRAPPER}} .ct-product-heading .ct-rect' => 'fill: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-4',
				],
			]
		);

		// Border Color.
		$this->add_control(
			'feature_product_bg_border_color', [
				'label'         => esc_html__('Border Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-product-heading .ct-border' => 'fill: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-4',
				],
			]
		);

		// Alignment.
		$this->add_responsive_control(
			'ct_heading_text_align', [
				'label'         => esc_html__('Alignment', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::CHOOSE,
				'options'       => [
					'left' 		=> [
						'title' => esc_html__('Left', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__('Center', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__('Right', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'       => 'center',
				'selectors'     => [
					'{{WRAPPER}} .ct-product-heading, {{WRAPPER}} .ct-price' => 'text-align: {{VALUE}};',
				],
			]
		);

		// Title Padding.
		$this->add_responsive_control(
			'ct_heading_text_padding', [
				'label'         => esc_html__('Padding', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'default'       => [
					'top'       => '15',
					'right'     => '15',
					'bottom'    => '15',
					'left'      => '15',
					'unit'      => 'px',
				],
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 td.ct-product-heading,
					{{WRAPPER}} .acte.ct-style-2 td.ct-product-heading .ct-product-title,
					{{WRAPPER}} .acte.ct-style-3 td.ct-product-heading .ct-product-title,
					{{WRAPPER}} .acte.ct-style-4 td.ct-product-heading
					{{WRAPPER}} .acte.ct-style-6 td.ct-product-heading,
					{{WRAPPER}} .acte.ct-style-8 td.ct-product-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Product Image.
		$this->add_control(
			'ct_product_image_style', [
				'label'         => esc_html__('Product Image', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
				'separator'     => 'before',
			]
		);

		// Image Width.
		$this->add_responsive_control(
			'ct_image_width', [
				'label'         => esc_html__('Image Width', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::SLIDER,
				'size_units'    => [ 'px','%' ],
				'range' 		=> [
					'px'        => [
                        'min'   => 0,
                        'max'   => 1000,						
						'step'  => 1,
                    ],
					'%'        => [
						'min'  => 0,
						'max'  => 100,
					],
				],
				'default'      => [
					'unit'     => '%',
					'size'     => 80,
				],
				'selectors'    => [
                    '{{WRAPPER}} .ct-product-img' => 'width: {{SIZE}}{{UNIT}};',
                ],
				
			]
		);

		// Margin.
		$this->add_responsive_control(
			'ct_product_image_margin', [
				'label'         => esc_html__('Margin', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-product-img' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-2'
				],
			]
		);

		// Image Width.
		$this->add_responsive_control(
			'ct_image_bg_size', [
				'label'         => esc_html__('Image Background Size', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::SLIDER,
				'size_units'    => [ 'px' ],
				'range' 		=> [
					'px'        => [
                        'min'   => 90,
                        'max'   => 250,						
						'step'  => 1,
                    ],
				],
				'default'      => [
					'unit'     => 'px',
					'size'     => 120,
				],
				'selectors'    => [
                    '{{WRAPPER}} .acte.ct-style-8 .ct-product-image' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
				'condition' 	=> [
					'ct_skin' 	=> ['style-8'],
				],
			]
		);


		// Image Background Color.
		$this->add_control(
			'ct_product_bg', [
				'label'         => esc_html__('Image Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-product-image,
					{{WRAPPER}} .ct-product-image:after,
					{{WRAPPER}} .ct-product-image:before,
					{{WRAPPER}} .acte.ct-style-8 .ct-product-image' => 'background-color: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> ['style-3', 'style-8']
				],
			]
		);

		// Price.
		$this->add_control(
			'ct_product_box_price_style', [
				'label'         => esc_html__('Price', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
				'separator'     => 'before',
			]
		);

		// Price Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'ct_product_price_text_typography',
				'selector'      => '{{WRAPPER}} .ct-feature.ct-product-price,
				{{WRAPPER}} .ct-product-price',
				'condition' 	=> [
					'ct_skin!' 	=> 'style-4',
				],
			]
		);

		// Text Color.
		$this->add_control(
			'ct_product_price_text_color', [
				'label'         => esc_html__('Text Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-feature.ct-product-price' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ct-product-heading .ct-product-price' => 'color: {{VALUE}};',
				],
			]
		);

		// Background Color.
		$this->add_control(
			'ct_product_price_bg_color_1', [
				'label'         => esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'
					{{WRAPPER}} .acte.ct-style-1 .ct-product-price,
					{{WRAPPER}} .acte.ct-style-2 .ct-product-price,
					{{WRAPPER}} .acte.ct-style-6 .ct-product-price span,
					{{WRAPPER}} .acte.ct-style-7 table tr:first-child td' => 'background-color: {{VALUE}} !important;',
				],
				'condition' 	=> [
					'ct_skin'	=> ['style-1', 'style-2', 'style-6', 'style-7']
				],
			]
		);

		// Price Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'ct_product_price_text_typography_4',
				'selector'      => '{{WRAPPER}} .ct-product-heading .ct-product-price',
				'condition' 	=> [
					'ct_skin' 	=> 'style-4',
				],
			]
		);

		// Border.
		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'          => 'price_border',
				'label'         => esc_html__('Border', 'advanced-comparison-table-for-elementor'),
				'fields_options'=> [
					'border'    => [
						'default' 	 	=> 'dashed',
					],
					'width'     	 => [
						'default' 	 => [
							'top'    => 1,
							'right'  => 1,
							'bottom' => 1,
							'left'   => 1,
						],
					],
					'color'  		=> [
						'default' 	=> '#F6B759',
					],
				],
				'selector'   	=> '{{WRAPPER}} .ct-feature.ct-product-price',
				'label_block'   => true,
				'condition' 	=> [
					'ct_skin' 	=> 'style-1',
				],
			]
		);

		// Price Width.
		$this->add_responsive_control(
			'ct_product_price_width', [
				'label'         => esc_html__('Price Width', 'advanced-comparison-table-for-elementor'),
				'type'			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 		=> [
						'min' 	=> 0,
						'max' 	=> 100,
						'step' 	=> 5,
					],
				],
				'default' 		=> [
					'unit' 		=> '%',
					'size' 		=> 50,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .acte.ct-style-4 .ct-product-price svg' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-4',
				],
			]
		);

		// Position.
		$this->add_responsive_control(
            'ct_price_position', [
                'label'         => esc_html__('Position', 'advanced-comparison-table-for-elementor'),
                'type'          => Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range'         => [
                    'px'        => [
                        'min'   => -50,
                        'max'   => 50,
                    ],
                ],
				'default' 		=> [
					'unit' 		=> 'px',
					'size' 		=> -50,
				],
                'selectors'     => [
                    '{{WRAPPER}} .acte.ct-style-4 .ct-product-price' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
				'condition' 	=> [
					'ct_skin'   => 'style-4'
				],
            ]
        );

		// Margin.
		$this->add_responsive_control(
			'ct_product_price_margin', [
				'label'         => esc_html__('Margin', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-feature.ct-product-price' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin'   => 'style-2'
				],
			]
		);

		// Border Radius.
		$this->add_control(
			'ct_product_price_border_radius', [
				'label'         => esc_html__('Border Radius', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'default'       => [
					'unit'      => 'px',
					'top'       => 50,
					'right'     => 50,
					'bottom'    => 50,
					'left'      => 50,
				],
				'selectors'     => [
					'{{WRAPPER}} .ct-feature.ct-product-price' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin'   => ['style-1','style-2']
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name' => 'ct_product_price_shadow',
				'selector' => '{{WRAPPER}} .acte.ct-style-6 .ct-product-price span',
				'condition' 	=> [
					'ct_skin' 	=> 'style-6',
				],
			]
		);

		// Alignment.
		$this->add_responsive_control(
			'ct_price_text_align', [
				'label'         => esc_html__('Alignment', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::CHOOSE,
				'options'       => [
					'left' 		=> [
						'title' => esc_html__('Left', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__('Center', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__('Right', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'       => 'center',
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-3 .ct-product-price' => 'text-align: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> 'style-3',
				],
			]
		);

		// Padding.
		$this->add_responsive_control(
			'ct_product_price_text_padding', [
				'label'         => esc_html__('Padding', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-style-2 .ct-feature.ct-product-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .ct-style-3 .ct-feature.ct-product-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .ct-style-5 .ct-product-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .ct-style-7 .ct-product-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin' 	=> ['style-2', 'style-3', 'style-5', 'style-7']
				],
			]
		);

		// Feature.
        $this->add_control(
			'ct_product_box_feature_style', [
				'label'         => esc_html__('Feature', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
				'separator'     => 'before',
			]
		);

		// Feature Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'ct_product_feature_text_typography',
				'selector'      => '{{WRAPPER}} .ct-feature',
			]
		);

		// Feature Text Color.
        $this->add_control(
			'ct_product_features_text_color', [
				'label'         => esc_html__('Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#000000',
				'selectors'     => [
					'{{WRAPPER}} .ct-feature' => 'color: {{VALUE}};',
				],
			]
		);

		// Check Icon Color.
		$this->add_control(
			'ct_features_check_color', [
				'label'         => esc_html__('Check Icon Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#0AB179',
				'selectors'     => [
					'{{WRAPPER}} .ct-feature i.fa.fa-check' => 'color: {{VALUE}};',
				],
			]
		);

		// Close Icon Color.
		$this->add_control(
			'ct_features_close_color', [
				'label'         => esc_html__('Close Icon Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#F44336',
				'selectors'     => [
					'{{WRAPPER}} .ct-feature i.fa.fa-close' => 'color: {{VALUE}};',
				],
			]
		);

		// Feature Alignment.
		$this->add_responsive_control(
			'ct_product_feature_text_align', [
				'label'         => esc_html__('Alignment', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::CHOOSE,
				'options'       => [
					'left' 		=> [
						'title' => esc_html__('Left', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__('Center', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__('Right', 'advanced-comparison-table-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'       => 'center',
				'selectors'     => [
					'{{WRAPPER}} .ct-feature' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'ct_product_feature_text_padding', [
				'label'         => esc_html__('Padding', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-feature, {{WRAPPER}} .ct-feature-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        // End Products Style Tab.

        // Start Button Style Tab.
        $this->start_controls_section(
			'ct_button_style', [
				'label'         => esc_html__('Button', 'advanced-comparison-table-for-elementor'),
				'tab'           => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'ct_button_heading_style', [
				'label'         => esc_html__('Heading', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'ct_button_heading_color', [
				'label'         => esc_html__('Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-feature-heading-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'ct_button_heading_bg_color', [
				'label'         => esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .acte.ct-style-1 .ct-feature-heading-button,
					{{WRAPPER}} .acte.ct-style-2 .ct-feature-heading-button,
					{{WRAPPER}} .acte.ct-style-3 .ct-feature-heading-button,
					{{WRAPPER}} .acte.ct-style-4 .ct-feature-heading-button,
					{{WRAPPER}} .acte.ct-style-5 .ct-feature-heading-button,
					{{WRAPPER}} .acte.ct-style-7 .ct-feature-heading-button,
					{{WRAPPER}} .acte.ct-style-5 table tr:last-child td:first-child,
					{{WRAPPER}} .acte.ct-style-6 table tr:last-child .ct-feature-title,
					{{WRAPPER}} .acte.ct-style-8 table tr:last-child .ct-feature-title' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'button_heading_typography',
				'selector'      => '{{WRAPPER}} .ct-feature-heading-button',
			]
		);

        $this->add_control(
			'ct_button_head_style', [
				'label'         => esc_html__('Button', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::HEADING,
				'separator'     => 'before',
			]
		);

		$this->start_controls_tabs(
			'ct_button_style_tabs'
		);

		$this->start_controls_tab(
			'ct_button_style_normal_tab', [
				'label'         => esc_html__('Normal', 'advanced-comparison-table-for-elementor'),
			]
		);

		$this->add_control(
			'ct_button_color', [
				'label'         => esc_html__('Text Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#000',
				'selectors'     => [
					'{{WRAPPER}} .ct-product-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'ct_btn_background_color', [
				'label'         => esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'default'       => '#F6B759',
				'selectors'     => [
					'{{WRAPPER}} .ct-style-1 .ct-product-btn,
					{{WRAPPER}} .ct-style-2 .ct-product-btn,
					{{WRAPPER}} .ct-style-4 .ct-product-btn,
					{{WRAPPER}} .ct-style-3 .ct-feature-button,
					{{WRAPPER}} .acte.ct-style-5 .ct-product-btn,
					{{WRAPPER}} .acte.ct-style-6 .ct-product-btn,
					{{WRAPPER}} .acte.ct-style-7 .ct-product-btn,
					{{WRAPPER}} .acte.ct-style-8 .ct-product-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'ct_button_style_hover_tab', [
				'label'         => esc_html__('Hover', 'advanced-comparison-table-for-elementor'),
			]
		);

		$this->add_control(
			'ct_button_color_hover', [
				'label'         => esc_html__('Text Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-style-1 .ct-product-btn:hover,
					{{WRAPPER}} .ct-style-2 .ct-product-btn:hover,
					{{WRAPPER}} .ct-style-4 .ct-product-btn:hover,
					{{WRAPPER}} .ct-style-3 .ct-feature-button:hover .ct-product-btn,
					{{WRAPPER}} .acte.ct-style-5 .ct-product-btn:hover,
					{{WRAPPER}} .acte.ct-style-6 .ct-product-btn:hover,
					{{WRAPPER}} .acte.ct-style-7 .ct-product-btn:hover,
					{{WRAPPER}} .acte.ct-style-8 .ct-product-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'ct_btn_background_color_hover', [
				'label'         => esc_html__('Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-style-1 .ct-product-btn:hover,
					{{WRAPPER}} .ct-style-2 .ct-product-btn:hover,
					{{WRAPPER}} .ct-style-4 .ct-product-btn:hover,
					{{WRAPPER}} .ct-style-3 .ct-feature-button:hover,
					{{WRAPPER}} .acte.ct-style-5 .ct-product-btn:hover,
					{{WRAPPER}} .acte.ct-style-6 .ct-product-btn:hover,
					{{WRAPPER}} .acte.ct-style-7 .ct-product-btn:hover,
					{{WRAPPER}} .acte.ct-style-8 .ct-product-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'ct_btn_border_color_hover', [
				'label'         => esc_html__('Border Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} .ct-product-btn:hover' => 'border-color: {{VALUE}};',
				],
				'condition' 	=> [
					'ct_skin!' 	=> 'style-3',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'ct_btn_clm_background_color', [
				'label'         => esc_html__('Column Background Color', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::COLOR,
				'selectors'     => [
					'{{WRAPPER}} tr:last-child td' => 'background-color: {{VALUE}};',
				],
                'separator'     => 'before',
				'condition' 	=> [
					'ct_skin' 	=> ['style-1', 'style-2', 'style-4'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'          => 'ct_col_box_shadow',
				'label'         => esc_html__('Column Box Shadow', 'advanced-comparison-table-for-elementor'),
				'selector'      => '{{WRAPPER}} tr:last-child td',
				'condition' 	=> [
					'ct_skin' 	=> 'style-2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'          => 'btn_text_typography',
				'label'         => esc_html__('Typography', 'advanced-comparison-table-for-elementor'),
				'selector'      => '{{WRAPPER}} .ct-product-btn',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'          => 'ct_button_shadow',
				'label'         => 'Box Shadow',
				'selector'      => '{{WRAPPER}} .ct-product-btn',
				'condition' 	=> [
					'ct_skin!' 	=> 'style-3',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'          => 'ct_btn_border',
				'label'         => esc_html__('Border', 'advanced-comparison-table-for-elementor'),
				'selector'      => '{{WRAPPER}} .ct-product-btn',
				'condition' 	=> [
					'ct_skin!'  => 'style-3',
				],
			]
		);

		$this->add_control(
			'ct_btn_border_radius', [
				'label'         => esc_html__('Border Radius', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-product-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin!'  => 'style-3',
				],
			]
		);

		$this->add_responsive_control(
			'ct_button_padding', [
				'label'         => esc_html__('Padding', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', 'em', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-product-btn ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin!' 	=> 'style-3',
				],
			]
		);

		$this->add_responsive_control(
			'ct_button_margin', [
				'label'         => esc_html__('Margin', 'advanced-comparison-table-for-elementor'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%' ],
				'selectors'     => [
					'{{WRAPPER}} .ct-product-btn ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'ct_skin!' 	=> 'style-3',
				],
			]
		);

		$this->end_controls_section();
        // End Button Style Tab.

    }

    // Function for counting products.
    public function add_condition_value( $j ) {

		$value = [];

		for ( $i = $j; $i < 7; $i++ ) {
			$value[] = $i;
		}
		return $value;

	}

    /**
     * Render Comparison Table Elements widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @access protected
     */
    protected function render() {

        $settings = $this->get_settings();
		$id = '.elementor-element-' . $this->get_id();

        switch ($settings['ct_skin']) {
            case 'style-1':
                include ACTE_PATH . 'include/advanced-comparison-table/style-1.php'; // Style 1
                break;
			case 'style-2':
				include ACTE_PATH . 'include/advanced-comparison-table/style-2.php'; // Style 2
				break;
			case 'style-3':
				include ACTE_PATH . 'include/advanced-comparison-table/style-3.php'; // Style 3
				break;
			case 'style-4':
				include ACTE_PATH . 'include/advanced-comparison-table/style-4.php'; // Style 4
				break;
			case 'style-5':
				include ACTE_PATH . 'include/advanced-comparison-table/style-5.php'; // Style 5
				break;
			case 'style-6':
				include ACTE_PATH . 'include/advanced-comparison-table/style-6.php'; // Style 6
				break;
			case 'style-7':
				include ACTE_PATH . 'include/advanced-comparison-table/style-7.php'; // Style 7
				break;
			case 'style-8':
				include ACTE_PATH . 'include/advanced-comparison-table/style-8.php'; // Style 8
				break;
            default:
                include ACTE_PATH . 'include/advanced-comparison-table/style-1.php'; // Default
                break;
        }?>

		<style>
		<?php 
		$column_spacing = isset($settings['ct_box_column_spacing']['size']) ? esc_attr($settings['ct_box_column_spacing']['size']) : '15'; // Default to 0
		$row_spacing = isset($settings['ct_box_row_spacing']['size']) ? esc_attr($settings['ct_box_row_spacing']['size']) : '15'; // Default to 0
		?>
		<?php echo esc_attr($id); ?> .acte.ct-style-3 table {
			border-spacing: <?php echo $column_spacing; ?>px <?php echo $row_spacing; ?>px;
		}
		@media (max-width: <?php echo esc_attr($settings['ct_tab_format']['size']);?>px)  {
			<?php echo esc_attr($id);?> .acte ul {
				display: flex;
			}
			<?php echo esc_attr($id);?> .acte tr td:nth-child(2) {
				display: table-cell;
			}
			<?php echo esc_attr($id);?> .acte td:nth-child(1) {
				display: table-cell;
			}
			<?php echo esc_attr($id);?> .acte td {
				display: none;
			}
		}
		@media (min-width: calc(<?php echo esc_attr($settings['ct_tab_format']['size']);?>px + 1px))  {
			<?php echo esc_attr($id);?> .acte td {
				display: table-cell !important;
			}
			<?php echo esc_attr($id);?> .acte td.ct-hide {
				display: none !important;
			}
		}
		</style><?php

    }

}

Plugin::instance()->widgets_manager->register(new ACTE_Widget());