<?php
/** 
 * Aimentor Customizer data
 */

function aimentor_customizer( $data ) {
	$aimentor_elementor_template_list = aimentor_get_elementor_templates();
	$aimentor_elementor_header_templates = aimentor_get_elementor_header_templates();
	return array(
		'panel' => array ( 
			'id' => 'aimentor',
			'name' => esc_html__('Aimentor Customizer','aimentor'),
			'priority' => 10,
			'section' => array(
				'header_setting' => array(
					'name' => esc_html__( 'Header Topbar Setting', 'aimentor' ),
					'priority' => 10,
					'fields' => array(
						array(
							'name' => esc_html__( 'Topbar Swicher', 'aimentor' ),
							'id' => 'aimentor_topbar_switch',
							'default' => false,
							'type' => 'switch',
							'transport'	=> 'refresh'
						),						
						array(
							'name' => esc_html__( 'Show Button', 'aimentor' ),
							'id' => 'aimentor_show_header_btn',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Text', 'aimentor' ),
							'id' => 'aimentor_header_btn_text',
							'default' => esc_html__('Sign in','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Link', 'aimentor' ),
							'id' => 'aimentor_header_btn_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Button Icon', 'aimentor' ),
							'id' => 'aimentor_header_btn_icon',
							'default' => esc_html__('fa fa-user-o', 'aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** investment button **/	
						array(
							'name' => esc_html__( 'Show Investment Offer Link', 'aimentor' ),
							'id' => 'aimentor_show_investment_offer_link',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Text', 'aimentor' ),
							'id' => 'aimentor_header_link_text',
							'default' => esc_html__('Aimentor Offer','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Url', 'aimentor' ),
							'id' => 'aimentor_header_link_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** contact-info **/
						array(
							'name' => esc_html__( 'Show Contact Info', 'aimentor' ),
							'id' => 'aimentor_show_contact_info',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Email Address', 'aimentor' ),
							'id' => 'aimentor_header_email',
							'default' => esc_html__('info@gmail.com','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Phone Number', 'aimentor' ),
							'id' => 'aimentor_header_phone',
							'default' => esc_html__('+97657945737', 'aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						)

					) 
				),
				'aimentor_topbar_social_profiles_setting' => array(
					'name' => esc_html__( 'Header Social Profiles', 'aimentor' ),
					'priority' => 15,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Social Profiles', 'aimentor' ),
							'id' => 'aimentor_show_social_profiles',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Facebook Url', 'aimentor' ),
							'id' => 'aimentor_topbar_fb_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Twitter Url', 'aimentor' ),
							'id' => 'aimentor_topbar_twitter_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Linkedin Url', 'aimentor' ),
							'id' => 'aimentor_topbar_linkedin_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Instagram Url', 'aimentor' ),
							'id' => 'aimentor_topbar_instagram_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					) 
				),
				'header_main_setting' => array(
					'name' => esc_html__( 'Header Setting', 'aimentor' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Choose Header Style', 'aimentor' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'header-style-1' => esc_html__( 'Header Style 1', 'aimentor' ),
								'header-style-2' => esc_html__( 'Header Style 2', 'aimentor' ),
							),
							'default' => 'header-style-2',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Type', 'aimentor' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'default-header' => esc_html__( 'Default Header', 'aimentor' ),
								'elementor-header' => esc_html__( 'Elementor Header', 'aimentor' ),
							),
							'default' => 'default-header',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Elementor Templates', 'aimentor' ),
							'id' => 'choose_elementor_header',
							'type'     => 'select',
							'choices'  => $aimentor_elementor_header_templates,
							'transport'	=> 'refresh',
							'required' => ['header_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Header Logo', 'aimentor' ),
							'id' => 'logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Black Logo', 'aimentor' ),
							'id' => 'seconday_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Logo', 'aimentor' ),
							'id' => 'retina_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Black Logo', 'aimentor' ),
							'id' => 'retina_secondary_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Show Header Search', 'aimentor' ),
							'id' => 'aimentor_header_search_show',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
					) 
				),	
				'banner_main_setting' => array(
					'name' => esc_html__( 'Sub Banner Setting', 'aimentor' ),
					'priority' => 20,
					'fields' => array(
						
						array(
							'name' => esc_html__( 'Banner Image', 'aimentor' ),
							'id' => 'sub-banner-img',
							'default' => get_template_directory_uri() . '/assets/img/sub-banner-img.jpg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						
					) 
				),	
				'page_title_setting'=> array(
					'name'=> esc_html__('Page Title Setting','aimentor'),
					'priority'=> 30,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Choose Breadcrumb Style', 'aimentor' ),
							'id' => 'choose_default_breadcrumb',
							'type'     => 'select',
							'choices'  => array(
								'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'aimentor' ),
								'breadcrumb-style-2' => esc_html__( 'default', 'aimentor' ),
							),
							'default' => 'breadcrumb-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name'=>esc_html__('Breadcrumb BG Color','aimentor'),
							'id'=>'breadcrumb_bg_color',
							'default'=> esc_html__('#343a40','aimentor'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Page Title Background Image', 'aimentor' ),
							'id' => 'breadcrumb_bg_img',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Archive', 'aimentor' ),
							'id' => 'breadcrumb_archive',
							'default' => esc_html__('Archive for category','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Search', 'aimentor' ),
							'id' => 'breadcrumb_search',
							'default' => esc_html__('Search results for','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb tagged', 'aimentor' ),
							'id' => 'breadcrumb_post_tags',
							'default' => esc_html__('Posts tagged','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb posted by', 'aimentor' ),
							'id' => 'breadcrumb_artitle_post_by',
							'default' => esc_html__('Articles posted by','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page Not Found', 'aimentor' ),
							'id' => 'breadcrumb_404',
							'default' => esc_html__('Page Not Found','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page', 'aimentor' ),
							'id' => 'breadcrumb_page',
							'default' => esc_html__('Page','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Shop', 'aimentor' ),
							'id' => 'breadcrumb_shop',
							'default' => esc_html__('Shop','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Home', 'aimentor' ),
							'id' => 'breadcrumb_home',
							'default' => esc_html__('Home','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),					
					)
				),
				'blog_setting'=> array(
					'name'=> esc_html__('Blog Setting','aimentor'),
					'priority'=> 40,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Blog BTN', 'aimentor' ),
							'id' => 'aimentor_blog_btn_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Show Blog Btn Icon', 'aimentor' ),
							'id' => 'aimentor_blog_btn_icon_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Blog Button text', 'aimentor' ),
							'id' => 'aimentor_blog_btn',
							'default' => esc_html__('Read More','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),							
						array(
							'name' => esc_html__( 'Blog Button Icon', 'aimentor' ),
							'id' => 'aimentor_blog_btn_icon',
							'default' => esc_html__('fas fa-angle-double-right','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Title', 'aimentor' ),
							'id' => 'breadcrumb_blog_title',
							'default' => esc_html__('Blog','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Details Title', 'aimentor' ),
							'id' => 'breadcrumb_blog_title_details',
							'default' => esc_html__('Blog Details','aimentor'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),

					)
				),
				'aimentor_footer_setting' => array(
					'name'=> esc_html__('Footer Setting','aimentor'),
					'priority'=> 60,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Footer Elementor Templates', 'aimentor' ),
							'id' => 'choose_elementor_footer',
							'type'     => 'select',
							'choices'  => $aimentor_elementor_template_list,
							'transport'	=> 'refresh',
							'required' => ['footer_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Choose Footer Style', 'aimentor' ),
							'id' => 'choose_default_footer',
							'type'     => 'select',
							'choices'  => array(
								'footer-style-1' => esc_html__( 'Footer Style 1', 'aimentor' ),
								'footer-style-2' => esc_html__( 'Footer Style 2', 'aimentor' ),
								'footer-style-3' => esc_html__( 'Footer Style 3', 'aimentor' ),
							),
							'default' => 'footer-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Footer Background Image', 'aimentor' ),
							'id' => 'aimentor_footer_bg',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Footer BG Color','aimentor'),
							'id'=>'aimentor_footer_bg_color',
							'default'=> esc_html__('#f4f9fc','aimentor'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Copy Right','aimentor'),
							'id'=>'aimentor_copyright',
							'default'=> esc_html__('Copyright &copy; Aimentor 2023. All rights reserved','aimentor'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Scrollup','aimentor'),
							'id'=>'aimentor_scrollup_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),						
						array(
							'name'=>esc_html__('Enable Footer Widgets','aimentor'),
							'id'=>'aimentor_enable_footer_widgets',
							'default'=> true,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Preloader','aimentor'),
							'id'=>'aimentor_preloader_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						)
					)
				),
				'error_page_setting'=> array(
					'name'=> esc_html__('404 Setting','aimentor'),
					'priority'=> 90,
					'fields'=> array(
						array(
							'name'=>esc_html__('400 Text','aimentor'),
							'id'=>'aimentor_error_404_text',
							'default'=> esc_html__('404','aimentor'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Not Found Title','aimentor'),
							'id'=>'aimentor_error_title',
							'default'=> esc_html__('Page not found','aimentor'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Description Text','aimentor'),
							'id'=>'aimentor_error_desc',
							'default'=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','aimentor'),
							'type'=>'textarea',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Link Text','aimentor'),
							'id'=>'aimentor_error_link_text',
							'default'=> esc_html__('Back To Home','aimentor'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						)
						
					)
				),
			),
		)
	);

}

add_filter('aimentor_customizer_data', 'aimentor_customizer');


