<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor aimentor-blog-post Widget.
 *
 * Elementor widget that uses the aimentor-blog-post control.
 *
 * @since 1.0.0
 */
class Elementor_Aimentor_Blog_Post_Widget extends \Elementor\Widget_Base {
	/**
	 * Get widget name.
	 *
	 * Retrieve aimentor-blog-post widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'aimentor-blog-post';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve aimentor-blog-post widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'AiMentor Blog Posts', 'elementor-aimentor-blog-post-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve aimentor-blog-post widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */

	/**
	 * Register aimentor-blog-post widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-aimentor-blog-post-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'selected_style',
			[
				'label' => esc_html__( 'Select Style', 'elementor-aimentor-blog-post-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1', // Set the default style
				'options' => [
					'style1' => esc_html__( 'Style 1', 'elementor-aimentor-blog-post-control' ),
					'style2' => esc_html__( 'Style 2', 'elementor-aimentor-blog-post-control' ),
					'style3' => esc_html__( 'Style 3', 'elementor-aimentor-blog-post-control' ),
				],
			]
		);	
		$this->add_control(
			'number_of_post_blogs',
			[
				'label' => __( 'Number of Posts', 'elementor-aimentor-blog-post-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 3, // Set a default value
				'min' => 1,
				'max' => 100,
				'step' => 1,
			]
		);
		$this->add_control(
			'post_blog_category',
			[
				'label' => esc_html__( 'Select Post Category', 'elementor-aimentor-blog-post-control' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $this->get_post_blog_categories(),
				'default' => 'post',
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'post_order_section',
			[
				'label' => esc_html__('Post Order', 'elementor-aimentor-blog-post-control'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'   => esc_html__('Post Order', 'elementor-aimentor-blog-post-control'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'asc'  => [
						'title' => esc_html__('Ascending', 'elementor-aimentor-blog-post-control'),
						'icon'  => 'fa fa-sort-amount-asc',
					],
					'desc' => [
						'title' => esc_html__('Descending', 'elementor-aimentor-blog-post-control'),
						'icon'  => 'fa fa-sort-amount-desc',
					],
				],
				'default' => 'desc',
			]
		);
		
		$this->add_control(
			'post_order_by',
			[
				'label'   => esc_html__('Sort Order', 'elementor-aimentor-blog-post-control'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'date'  => [
						'title' => esc_html__('Latest Posts', 'elementor-aimentor-blog-post-control'),
						'icon'  => 'fa fa-calendar',
					],
					'title' => [
						'title' => esc_html__('Alphabetical Order', 'elementor-aimentor-blog-post-control'),
						'icon'  => 'fa fa-sort-alpha-asc',
					],
				],
				'default' => 'date',
			]
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'image_section',
			[
				'label' => esc_html__( 'Image Controls', 'elementor-aimentor-blog-post-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_responsive_control(
			'image_size',
			[
				'label' => esc_html__( 'Image Size', 'elementor-aimentor-blog-post-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'full', // Set your default image size
				'options' => [
					'thumbnail' => 'Thumbnail',
					'medium' => 'Medium',
					'large' => 'Large',
					'full' => 'Full',
				],
			]
		);
		
		$this->end_controls_section();
        
	}
		/**
	 * Get aimentor-blog-post categories.
	 *
	 * Retrieve the aimentor-blog-post categories to populate the category control.
	 *
	 * @since 1.0.0
	 * @access protected
	 * @return array aimentor-blog-post categories.
	 */
	protected function get_post_blog_categories() {
		$categories = get_categories( array( 'taxonomy' => 'category' ) );
		$options = array();

		foreach ( $categories as $category ) {
			$options[ $category->term_id ] = $category->name;
		}
		return $options;
	}
	/**
	 * Render aimentor-blog-post widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$selected_style = $settings['selected_style'];
		$number_of_post_blogs = $settings['number_of_post_blogs'];
		$category = $settings['post_blog_category'];
		$image_size = $settings['image_size']; // Get the selected image size
		// Get user-selected post order (ascending or descending)
		$post_order = ($settings['post_order'] === 'desc') ? 'DESC' : 'ASC';
		// Get user-selected sorting order (latest posts or alphabetical)
		$post_order_by = ($settings['post_order_by'] === 'date') ? 'date' : 'title';
		
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => $number_of_post_blogs,
			'order'          => $post_order,    // Use user-selected post order
			'orderby'        => $post_order_by, // Use user-selected sorting order
		);
		
		// Check if a specific category is selected
		if (!empty($category) && $category != 'post') {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'category',
					'field'    => 'Name',
					'terms'    => $category,
				),
			);
		}
		
		$result = new WP_Query($args);
		if($selected_style === 'style1') {
			echo '<div class="blog-section">';
			if ($result->have_posts()) {
				echo '<div class="row">';
				$count = 0;
				while ($result->have_posts()) {
					$result->the_post();
					$post_id = get_the_ID();
					$meta = get_the_post_thumbnail(get_the_ID(), 'large');
					$comment_count = get_comments_number($post_id);
					$post_date = get_the_date('M d, Y', $post_id);
					$author_name = get_the_author();
					?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-12">
						<div class="blog-inner-box">
							<figure class="mb-0">
								<?php
								if(has_post_thumbnail()) {
									echo the_post_thumbnail();
								}
								else {
									?>
									<img src="<?php echo PLUGIN_BASE_URI . '/assets/images/blog-default-img.jpg'?>">
									<?php
								}
								?>
							</figure>
							<div class="blog-text-con">
								<ul class="list-unstyled">
									<li class="d-inline-block">
										<figure class="mb-0">
											<img src="<?php echo PLUGIN_BASE_URI . 'assets/images/blog-profile-default-img.png'?>">
										</figure>
									</li>
									<?php
									if ($author_name) {
										?>
										<li class="d-inline-block"><span><?php echo $author_name; ?></span></li>
										<?php
									}
									?>
								</ul>
								<a href="<?php echo the_permalink(); ?>">
									<h4><?php echo the_title(); ?></h4>
								</a>
								<div class="posted-details">
									<ul class="list-unstyled mb-0">
										<?php
										if($post_date) {
											?>
											<li class="d-inline-block"><i class="fas fa-calendar-alt"></i> <?php echo $post_date; ?></li>
											<?php
										}
										if($comment_count) {
											?>
											<li class="d-inline-block mr-0"><i class="fas fa-comments"></i> <?php echo $comment_count; ?> Comments</li>
											<?php
										}
										else {
											?>
											<li class="d-inline-block mr-0"><i class="fas fa-comments"></i> 0 Comments</li>
											<?php
										}
										?>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
			echo '</div>';
		}
		elseif($selected_style === 'style2') {
			echo '<div class="blog-post2">';
			if ($result->have_posts()) {
				echo '<div class="row">';
				$count = 0;
				while ($result->have_posts()) {
					$result->the_post();
					$post_id = get_the_ID();
					$meta = get_the_post_thumbnail(get_the_ID(), 'large');
					$author_name = get_the_author();
					?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-12">
						<div class="blog-post-content-box">
							<figure class="mb-0">
								<?php
								if(has_post_thumbnail()) {
									echo the_post_thumbnail();
								}
								else {
									?>
									<img src="<?php echo PLUGIN_BASE_URI . '/assets/images/blog-default-img.jpg'?>">
									<?php
								}
								?>
							</figure>
							<div class="blog-post2-content">
								<div class="blog-admin d-flex align-items-center">
									<figure class="mb-0">
										<img src="<?php echo PLUGIN_BASE_URI . 'assets/images/post-admin-icon.png'?>">
									</figure>
									<?php
									if ($author_name) {
										?>
										<span><?php echo $author_name; ?></span>
										<?php
									}
									?>
								</div>
								<a href="<?php echo the_permalink(); ?>"><h4 class="mb-0"><?php echo the_title(); ?></h4></a>
							</div>
						</div>
					</div>	
					<?php
				}
			}
			echo '</div>';
		}
		elseif($selected_style === 'style3') {
			echo '<div class="blog-section graphic-blog-section">';
			if ($result->have_posts()) {
				echo '<div class="row">';
				$count = 0;
				while ($result->have_posts()) {
					$result->the_post();
					$post_id = get_the_ID();
					$meta = get_the_post_thumbnail(get_the_ID(), 'large');
					$comment_count = get_comments_number($post_id);
					$post_date = get_the_date('M d, Y', $post_id);
					$author_name = get_the_author();
					?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-12">
						<div class="blog-inner-box">
							<figure class="mb-0">
								<?php
								if(has_post_thumbnail()) {
									echo the_post_thumbnail();
								}
								else {
									?>
									<img src="<?php echo PLUGIN_BASE_URI . '/assets/images/blog-default-img.jpg'?>">
									<?php
								}
								?>
							</figure>
							<div class="blog-text-con">
								<ul class="list-unstyled">
									<li class="d-inline-block">
										<figure class="mb-0">
											<img src="<?php echo PLUGIN_BASE_URI . 'assets/images/blog-profile-default-img.png'?>">
										</figure>
									</li>
									<?php
									if ($author_name) {
										?>
										<li class="d-inline-block"><span><?php echo $author_name; ?></span></li>
										<?php
									}
									?>
								</ul>
								<a href="<?php echo the_permalink(); ?>">
									<h4><?php echo the_title(); ?></h4>
								</a>
								<div class="posted-details">
									<ul class="list-unstyled mb-0">
										<?php
										if($post_date) {
											?>
											<li class="d-inline-block"><i class="fas fa-calendar-alt"></i> <?php echo $post_date; ?></li>
											<?php
										}
										if($comment_count) {
											?>
											<li class="d-inline-block mr-0"><i class="fas fa-comments"></i> <?php echo $comment_count; ?> Comments</li>
											<?php
										}
										else {
											?>
											<li class="d-inline-block mr-0"><i class="fas fa-comments"></i> 0 Comments</li>
											<?php
										}
										?>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
			echo '</div>';
		}
	}
	
	

}
