<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor aimentor-services Widget.
 *
 * Elementor widget that uses the aimentor-services control.
 *
 * @since 1.0.0
 */
class Elementor_Aimentor_Services_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve aimentor-services widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'aimentor-services';
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve aimentor-services widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'AiMentor Services', 'elementor-aimentor-services-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve aimentor-nav-menu widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-code';
	}

	/**
	 * Register aimentor-services widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        // Content Tab Controls Start
        $this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-aimentor-services-control' ),
				'type' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'selected_services',
			[
				'label' => esc_html__('Select Services', 'elementor-aimentor-services-control'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $this->get_services_options(), // Define a function to get available services options
			]
		);	
		$this->add_control(
			'selected_style',
			[
				'label' => esc_html__( 'Select Style', 'elementor-aimentor-services-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1', // Set the default style
				'options' => [
					'style1' => esc_html__( 'Style 1', 'elementor-aimentor-services-control' ),
					'style2' => esc_html__( 'Style 2', 'elementor-aimentor-services-control' ),
					'style3' => esc_html__( 'Style 3', 'elementor-aimentor-services-control' ),
					'style4' => esc_html__( 'Style 4', 'elementor-aimentor-services-control' ),
				],
			]
		);	
		$this->add_control(
			'number_of_services_box',
			[
				'label' => __( 'Number of Services', 'elementor-aimentor-services-control' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 4, // Set a default value
				'min' => 1,
				'max' => 100,
				'step' => 1,
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'query_section',
			[
				'label' => esc_html__('Query Settings', 'elementor-aimentor-services-control'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'orderby',
			[
				'label' => esc_html__('Order By', 'elementor-aimentor-services-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'ID' => esc_html__('Post ID', 'elementor-aimentor-services-control'),
					'title' => esc_html__('Title', 'elementor-aimentor-services-control'),
					'date' => esc_html__('Date', 'elementor-aimentor-services-control'),
					// Add other options as needed
				],
				'default' => 'ID', // Default order by Post ID
			]
		);
		
		$this->add_control(
			'post_status',
			[
				'label' => esc_html__('Post Status', 'elementor-aimentor-services-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'publish' => esc_html__('Publish', 'elementor-aimentor-services-control'),
					'draft' => esc_html__('Draft', 'elementor-aimentor-services-control'),
					// Add other options as needed
				],
				'default' => 'publish', // Default post status is 'publish'
			]
		);
		
		$this->add_control(
			'order',
			[
				'label' => esc_html__('Order', 'elementor-aimentor-services-control'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'ASC' => esc_html__('Ascending', 'elementor-aimentor-services-control'),
					'DESC' => esc_html__('Descending', 'elementor-aimentor-services-control'),
				],
				'default' => 'DESC', // Default order is descending
			]
		);
        
	}

	private function get_services_options() {
		$options = [];
		$args = array(
			'post_type' => 'aimentor_services',
			'posts_per_page' => -1,
			'post_status' => 'publish',
		);
		$services = new WP_Query($args);
	
		if ($services->have_posts()) {
			while ($services->have_posts()) {
				$services->the_post();
				$options[get_the_ID()] = get_the_title();
			}
			wp_reset_postdata();
		}
	
		return $options;
	}
	/**
	 * Render aimentor-services widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$selected_style = $settings['selected_style'];
		$selected_services = $settings['selected_services'];
		$number_of_services_box = $settings['number_of_services_box'];
        ?>
        <?php
    	$args = array(
			'post_type' => 'aimentor_services',
			'orderby' => $this->get_settings('orderby'),
			'post_status' => $this->get_settings('post_status'),
			'order' => $this->get_settings('order'),
			'posts_per_page' => $number_of_services_box,
			'post__in' => $selected_services, // Include only the selected services
		);	
		$result = new WP_Query( $args );
		if($selected_style === 'style1') {
			?>
			<div class="services-section">
				<?php
				if ( $result-> have_posts() ) {
				?>
				<div class="row">
					<?php
					$count=0;
					while ( $result->have_posts() ){ 
						$result->the_post();
						$meta = get_post_meta(get_the_ID(),'services_thumbnail', true);
						?>
						<div class="col-lg-3 col-md-6 col-sm-6 col-12">
							<div class="collection-box">
								<figure>
									<img src="<?php echo $meta; ?>">
								</figure>
								<h4><?php echo get_the_title(); ?></h4>
								<p><?php echo wp_trim_words( get_the_content(), 9 ) ; ?></p>
								<a href="<?php echo get_the_permalink(); ?>"><i class="fas fa-arrow-right"></i></a>
							</div>
						</div>
					<?php
					$count++;
					}
					?>	
				</div>
			</div>
			<?php
			}
		}
		elseif($selected_style === 'style2') {
			?>
			<div class="services-section design-services-section">
				<?php
				if ( $result-> have_posts() ) {
				?>
				<div class="row">
					<?php
					$count=0;
					while ( $result->have_posts() ){ 
						$result->the_post();
						$meta = get_post_meta(get_the_ID(),'services_thumbnail', true);
							?>
							<div class="col-lg-6 col-md-6 col-sm-6 col-12">
								<div class="collection-box">
									<figure>
										<img src="<?php echo $meta; ?>">
									</figure>
									<h4><?php echo get_the_title(); ?></h4>
									<p><?php echo wp_trim_words( get_the_content(), 9 ) ; ?></p>
									<a href="<?php echo get_the_permalink(); ?>"><i class="fas fa-arrow-right"></i></a>
								</div>
							</div>	
							<?php
						$count++;
					}
					?>	
				</div>
				<?php
				}
				?>
			</div>
		<?php
		}
		elseif($selected_style === 'style3') {
			?>
			<div class="services-section future-services-section">
				<?php
				if ( $result-> have_posts() ) {
				?>
				<div class="row">
					<?php
					$count=0;
					while ( $result->have_posts() ){ 
						$result->the_post();
						$meta = get_post_meta(get_the_ID(),'services_thumbnail', true);
							?>
							<div class="col-lg-6 col-md-6 col-sm-6 col-12">
								<div class="collection-box">
									<figure>
										<img src="<?php echo $meta; ?>">
									</figure>
									<h4><?php echo get_the_title(); ?></h4>
									<p><?php echo wp_trim_words( get_the_content(), 6 ) ; ?></p>
									<a href="<?php echo get_the_permalink(); ?>"><i class="fas fa-arrow-right"></i></a>
								</div>
							</div>	
							<?php
						$count++;
					}
					?>	
				</div>
				<?php
				}
				?>
			</div>
		<?php
		}
		elseif($selected_style === 'style4') {
			?>
			<div class="services-section graphic-services-section">
				<?php
				if ( $result-> have_posts() ) {
				?>
				<div class="row">
					<?php
					$count=0;
					while ( $result->have_posts() ){ 
						$result->the_post();
						$meta = get_post_meta(get_the_ID(),'services_thumbnail', true);
						?>
						<div class="col-lg-3 col-md-6 col-sm-6 col-12">
							<div class="collection-box">
								<figure>
									<img src="<?php echo $meta; ?>">
								</figure>
								<h4><?php echo get_the_title(); ?></h4>
								<p><?php echo wp_trim_words( get_the_content(), 9 ) ; ?></p>
								<a href="<?php echo get_the_permalink(); ?>"><i class="fas fa-arrow-right"></i></a>
							</div>
						</div>
					<?php
					$count++;
					}
					?>	
				</div>
			</div>
			<?php
			}
		}
	}
}
