<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
 
/**
 * Elementor aimentor-team Widget.
 *
 * Elementor widget that uses the aimentor-team control.
 *
 * @since 1.0.0
 */
class Elementor_Aimentor_Team_Widget extends \Elementor\Widget_Base
{
 
    /**
     * Get widget name.
     *
     * Retrieve aimentor-team widget name.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'aimentor-team';
    }
 
    /**
     * Get widget title.
     *
     * Retrieve aimentor-team widget title.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('AiMentor Team', 'elementor-aimentor-team-control');
    }
 
    /**
     * Get widget icon.
     *
     * Retrieve aimentor-team widget icon.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-posts-grid';
    }
 
    /**
     * Register aimentor-team widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
 
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'elementor-aimentor-team-control'),
                'type' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'selected_members',
            [
                'label' => esc_html__('Select Members', 'elementor-aimentor-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_teams_options(), // Define a function to get available services options
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'query_section',
            [
                'label' => esc_html__('Query Settings', 'elementor-aimentor-team-control'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
 
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'elementor-aimentor-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'ID' => esc_html__('Post ID', 'elementor-aimentor-team-control'),
                    'title' => esc_html__('Title', 'elementor-aimentor-team-control'),
                    'date' => esc_html__('Date', 'elementor-aimentor-team-control'),
                    // Add other options as needed
                ],
                'default' => 'ID', // Default order by Post ID
            ]
        );
 
        $this->add_control(
            'post_status',
            [
                'label' => esc_html__('Post Status', 'elementor-aimentor-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'publish' => esc_html__('Publish', 'elementor-aimentor-team-control'),
                    'draft' => esc_html__('Draft', 'elementor-aimentor-team-control'),
                    // Add other options as needed
                ],
                'default' => 'publish', // Default post status is 'publish'
            ]
        );
 
        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'elementor-aimentor-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'elementor-aimentor-team-control'),
                    'DESC' => esc_html__('Descending', 'elementor-aimentor-team-control'),
                ],
                'default' => 'DESC', // Default order is descending
            ]
        );
 
        $this->end_controls_section();
    }
 
    private function get_teams_options()
    {
        $options = [];
        $args = array(
            'post_type' => 'aimentor_teams',
            'posts_per_page' => -1,
            'post_status' => 'publish',
        );
        $services = new WP_Query($args);
 
        if ($services->have_posts()) {
            while ($services->have_posts()) {
                $services->the_post();
                $options[get_the_ID()] = get_the_title();
            }
            wp_reset_postdata();
        }
 
        return $options;
    }


    /**
     * Render aimentor-team widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
{
    $settings = $this->get_settings_for_display();
    $selected_members = $settings['selected_members'];
    $args = array(
        'post_type'      => 'aimentor_teams',
        'orderby'        => $this->get_settings('orderby'),
        'post_status'    => $this->get_settings('post_status'),
        'order'          => $this->get_settings('order'),
        'posts_per_page' => -1,
        'post__in'       => $selected_members, // Include only the selected services
    );
 
    $result = new WP_Query($args);
	echo '<div class="team-section">';
		echo '<div class="row">';
			while ($result->have_posts()) {
				$result->the_post();
				$url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
				$fb = get_post_meta(get_the_ID(), 'team_member_facebook_link', true);
				$instagram = get_post_meta(get_the_ID(), 'team_member_instagram_link', true);
				$twitter = get_post_meta(get_the_ID(), 'team_member_twitter_link', true);
				$linkedin = get_post_meta(get_the_ID(), 'team_member_linkedin_link', true);
				?>
				<div class="col-lg-3 col-md-6 col-sm-6 aos-init aos-animate" data-aos="fade-up" data-aos-duration="600">
						<div class="blog-inner-box">
							<a href="<?php echo get_post_permalink(); ?>">
								<figure class="mb-0">
									<img src="<?php echo $url; ?>">
								</figure>
							</a>
							<div class="blog-text-con text-center">
								<a href="<?php echo get_post_permalink(); ?>"><h4><?php echo get_the_title(); ?></h4></a>
								<span class="d-block"><?php echo get_the_excerpt(); ?></span>
								<div class="posted-details">
									<ul class="list-unstyled mb-0 d-flex align-items-center justify-content-center">
										<?php
										if($fb){
											?>
											<li class="ml-0"><a href="<?php echo $fb ?>"><i class="fab fa-facebook-f"></i></a></li>
											<?php
										}
										if($twitter) {
											?>
											<li><a href="<?php echo $twitter ?>"><i class="fab fa-twitter"></i></a></li>
											<?php
										}
										if($instagram) {
											?>
											<li><a href="<?php echo $instagram ?>"><i class="fab fa-instagram"></i></a></li>
											<?php
										}
										if($linkedin) {
											?>
											<li class="mr-0"><a href="<?php echo $linkedin ?>"><i class="fab fa-linkedin-in"></i></a></li>
											<?php
										}
										?>
									</ul>
								</div>
							</div>
						</div>
					</div>
				<?php
			}
		echo '</div>';
	echo '</div>';
    }
}