<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor aimentor-testimonial-slider Widget.
 *
 * Elementor widget that uses the aimentor-testimonial-slider control.
 *
 * @since 1.0.0
 */
class Elementor_Aimentor_Testimonial_Slider_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve aimentor-testimonial-slider widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'aimentor-testimonial-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve aimentor-testimonial-slider widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'AiMentor Testimonial Slider', 'elementor-aimentor-testimonial-slider-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve aimentor-testimonial-slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register aimentor-testimonial-slider widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-aimentor-testimonial-slider-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'selected_style',
			[
				'label' => esc_html__( 'Select Style', 'elementor-aimentor-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1', // Set the default style
				'options' => [
					'style1' => esc_html__( 'Style 1', 'elementor-aimentor-testimonial-slider-control' ),
					'style2' => esc_html__( 'Style 2', 'elementor-aimentor-testimonial-slider-control' ),
					'style3' => esc_html__( 'Style 3', 'elementor-aimentor-testimonial-slider-control' ),
				],
			]
		);	
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-aimentor-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'elementor-aimentor-testimonial-slider-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Image', 'elementor-aimentor-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => PLUGIN_BASE_URI. 'assets/images/testimonial-default-img.png' ,
				],
			]
		);
		$repeater->add_control(
			'list_name', [
				'label' => __( 'Name', 'elementor-aimentor-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Name' , 'elementor-aimentor-testimonial-slider-control' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_designation', [
				'label' => __( 'Designation', 'elementor-aimentor-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Designation' , 'elementor-aimentor-testimonial-slider-control' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Testimonial List', 'elementor-aimentor-testimonial-slider-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_content' => __( 'Content', 'elementor-aimentor-testimonial-slider-control' ),
						'list_image' => __( 'Image', 'elementor-aimentor-testimonial-slider-control' ),
						'list_name' => __( 'Name', 'elementor-aimentor-testimonial-slider-control' ),
						'list_designation' => __( 'Designation', 'elementor-aimentor-testimonial-slider-control' ),
					],
					[
						'list_content' => __( 'Content', 'elementor-aimentor-testimonial-slider-control' ),
						'list_image' => __( 'Image', 'elementor-aimentor-testimonial-slider-control' ),
						'list_name' => __( 'Name', 'elementor-aimentor-testimonial-slider-control' ),
						'list_designation' => __( 'Designation', 'elementor-aimentor-testimonial-slider-control' ),
					],
				],
			]
		);
	}


	/**
	 * Render aimentor-testimonial-slider widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$selected_style = $settings['selected_style'];
		if($selected_style === 'style1') {
			?>
			<div class="reviews-section testimonial-section">
				<div class="owl-carousel owl-theme">
					<?php
					if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {
							?>
							<div class="profile-box">
								<?php
								if($item['list_content']) {
									?>
									<p><?php echo strip_tags($item['list_content']) ?></p>
									<?php
								}
								?>	
								<figure class="testimonial-contentimage">
									<?php 
									if(isset($item['list_image']['id']) && !empty( $item['list_image']['id'] )) {
										?>
										<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
										<?php
									}
									else {
										?>
										<img src="<?php echo PLUGIN_BASE_URI .'/assets/images/testimonial-default-img.png'; ?>" alt="" class="img-fluid">
										<?php
									}
									?>
								</figure>
								<?php
								if($item['list_name']) {
									?>
									<h4><?php echo $item['list_name'] ?></h4>
									<?php
								}
								if($item['list_designation']) {
									?>
									<span><?php echo $item['list_designation'] ?></span>
									<?php
								}
								?>
							</div>                     
							<?php
						}
					}
					?>			
				</div>
			</div>
			<?php
		}
		elseif($selected_style === 'style2') {
			?>
			<div id="reviewsection" class="carousel slide testimonial-slider" data-ride="carousel">
                <div class="carousel-inner">
					<?php
					$count = 0;
					if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {
							?>
							<div class="carousel-item <?php echo ($count === 0)? 'active' : ''; ?>">
								<div class="testimonial-content text-center">
									<figure>
										<img src="<?php echo PLUGIN_BASE_URI .'/assets/images/quote-icon.png'; ?>" alt="quote-icon">
									</figure>
									<?php
										if($item['list_content']) {
											?>
											<p><?php echo strip_tags($item['list_content']) ?></p>
											<?php
										}
									?>	
									<div class="auther-con">
										<figure class="user-img">
											<?php 
												if(isset($item['list_image']['id']) && !empty( $item['list_image']['id'] )) {
													?>
													<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
													<?php
												}
												else {
													?>
													<img src="<?php echo PLUGIN_BASE_URI .'/assets/images/testimonial-default-img.png'; ?>" alt="" class="img-fluid">
													<?php
												}
											?>
										</figure>
										<?php
											if($item['list_name']) {
												?>
												<h4><?php echo $item['list_name'] ?></h4>
												<?php
											}
											if($item['list_designation']) {
												?>
												<span class="d-block"><?php echo $item['list_designation'] ?></span>
												<?php
											}
										?>
									</div>
								</div>
							</div>
							<?php
							$count++;
						}
					}
					?>
                </div>
                <a class="carousel-control-prev" href="#reviewsection" role="button" data-slide="prev">
                  <span class="carousel-control-prev-icon" aria-hidden="true">
				  	<img src="<?php echo PLUGIN_BASE_URI .'/assets/images/arrow-left.png'; ?>">
                  </span>
                </a>
                <a class="carousel-control-next" href="#reviewsection" role="button" data-slide="next">
                  <span class="carousel-control-next-icon" aria-hidden="true">
                    <img src="<?php echo PLUGIN_BASE_URI .'/assets/images/arrow-right.png'; ?>">
                  </span>
                </a>
              </div>
			  <?php
		}	
		elseif($selected_style === 'style3') {
			?>
			<div class="reviews-section graphic-reviews-section">
				<div class="owl-carousel owl-theme">
					<?php
					if ( $settings['list'] ) {
						foreach ( $settings['list'] as $item ) {
							?>
							<div class="profile-box">
								<figure class="testimonial-contentimage">
									<?php 
									if(isset($item['list_image']['id']) && !empty( $item['list_image']['id'] )) {
										?>
										<?php echo wp_get_attachment_image( $item['list_image']['id'], 'full' ); ?>
										<?php
									}
									else {
										?>
										<img src="<?php echo PLUGIN_BASE_URI .'/assets/images/testimonial-default-img.png'; ?>" alt="" class="img-fluid">
										<?php
									}
									?>
								</figure>
								<?php
								if($item['list_name']) {
									?>
									<h4><?php echo $item['list_name'] ?></h4>
									<?php
								}
								if($item['list_designation']) {
									?>
									<span><?php echo $item['list_designation'] ?></span>
									<?php
								}
								?>
								<figure class="quote-icon">
									<img src="<?php echo PLUGIN_BASE_URI .'/assets/images/quote-small-icon.png'; ?>" alt="quote-icon">
								</figure>
								<?php
								if($item['list_content']) {
									?>
									<p class="mb-0"><?php echo strip_tags($item['list_content']) ?></p>
									<?php
								}
								?>	
							</div>                     
							<?php
						}
					}
					?>			
				</div>
			</div>
			<?php
		}
	}

}