<?php
/**
 * Plugin Name:       GSheet Connector For Elementor Forms
 * Plugin URI:        https://demo.hulkplugins.com/elementor/elementor-forms-google-sheet-connector/
 * Description:       Send your Elementor Form data to your Google Spreadsheet.
 * Author:            HulkPlugins
 * Author URI:        https://hulkplugins.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       gsheet-connector-for-elementor-forms
 * Domain Path:       /languages
 * Version:           1.0.0
 * Requires PHP:      7.4
 * Requires at least: 6.2
 * Requires Plugins:  elementor-pro
 *
 * @package         HulkPlugins\ElementorPro\Forms\GSheetConnector
 *
 */

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector;

use HulkPlugins\ElementorPro\Forms\GSheetConnector\Controllers\SettingsController;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Models\SettingsModel;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Services\SettingsService;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Composer autoload
require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';

// Constants
require_once plugin_dir_path( __FILE__ ) . 'constants.php';

// Init
I18n::getInstance()->init_hooks();
Base::getInstance()->init_hooks();
$settingsModel = SettingsModel::getInstance();
$settingsService = SettingsService::getInstance( $settingsModel );
SettingsController::getInstance( $settingsService )->init_hooks();
