<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector;

use ElementorPro\Modules\Forms\Registrars\Form_Actions_Registrar;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Controllers\FormActionController;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Models\SheetModel;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Routes\ClientAuthRoute;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Routes\SettingsRoute;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Routes\SheetsRoute;
use HulkPlugins\ElementorPro\Forms\GSheetConnector\Traits\SingletonTrait;

class Base {
	use SingletonTrait;

	public function init_hooks() {
		add_filter( 'plugin_row_meta', [ $this, 'plugin_row_meta' ], 10, 2 );
		add_action( 'activated_plugin', [ $this,'activated' ] );
		add_action( 'rest_api_init', [ $this, 'rest_api_init' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_scripts' ] );
		add_action( 'elementor_pro/forms/actions/register', [ $this,'action_register' ] );
		add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'editor_enqueue_scripts' ] );
	}

	public static function getInstance(): Base {
		return self::__getInstance();
	}

	/**
	 * Add plugin meta
	 *
	 * @param $links
	 * @param $file
	 *
	 * @return array|mixed
	 */
	public function plugin_row_meta( $links, $file ) {

		if ( strpos( $file, 'gsheet-connector-for-elementor-forms.php' ) !== false ) {

			$row_meta['docs'] = sprintf(
			/** @lang text */                '<a target="_blank" href="%1$s" title="%2$s">%2$s</a>',
				esc_url( DOCUMENTATION ),
				esc_html__( 'Docs', 'gsheet-connector-for-elementor-forms' )
			);

			$row_meta['support'] = sprintf(
			/** @lang text */                '<a target="_blank" href="%1$s">%2$s</a>',
				esc_url( SUPPORT ),
				esc_html__( 'Help &amp; Support', 'gsheet-connector-for-elementor-forms' )
			);

			$links = array_merge( $links, $row_meta );
		}

		return $links;
	}

	/**
	 * Hooked into the 'activated_plugin' action to redirect to the settings page when the plugin is activated.
	 *
	 * @since 1.0.0
	 */
	public function activated( $plugin ) {
		if ( $plugin === 'gsheet-connector-for-elementor-forms/gsheet-connector-for-elementor-forms.php' ) {

			// Redirect to settings page
	        $settingsPageUrl = add_query_arg(
	            [
					'page' => 'gsheet-connector-for-elementor-forms-settings',
	            ],
	            admin_url( 'admin.php' )
	        );

	        wp_safe_redirect( $settingsPageUrl );
	        exit();
		}
	}

	/**
	 * Registers the REST API routes
	 *
	 * @return void
	 */
	public function rest_api_init() {
		new SettingsRoute();
		new ClientAuthRoute();
		new SheetsRoute();
	}

	/**
	 * Fires when scripts and styles are enqueued.
	 * @return void
	 */
	public function admin_scripts() {
		if ( ! wp_script_is( 'react-jsx-runtime', 'registered' ) ) {
			wp_register_script(
				'react-jsx-runtime',
				PLUGIN_DIR_URL . 'assets/js/react-jsx-runtime.js',
				[ 'react' ],
				'18.3.1',
				true
			);
		}
	}

	/**
	 * Registering Actions
	 * @param Form_Actions_Registrar $form_actions_registrar
	 *
	 * @return void
	 */
	public function action_register( Form_Actions_Registrar $form_actions_registrar ) {
		$form_actions_registrar->register( new FormActionController() );
	}

	/**
	 * After editor enqueue scripts.
	 *
	 * Fires after Elementor editor scripts are enqueued.
	 */
	public function editor_enqueue_scripts() {

		$assets = require_once PLUGIN_DIR_PATH . 'build/editor/index.asset.php';

		wp_enqueue_style(
			PREFIX . 'editor',
			PLUGIN_DIR_URL . 'build/editor/index.css',
			[ 'elementor-editor' ],
			$assets['version'],
		);

		wp_enqueue_script(
			PREFIX . 'editor',
			PLUGIN_DIR_URL . 'build/editor/index.js',
			[ 'jquery', 'elementor-editor' ],
			$assets['version'],
			true
		);

		wp_localize_script(
			PREFIX . 'editor',
			PREFIX . 'settings',
			[
				'GROUP'   => GROUP,
				'PREFIX'  => PREFIX,
				'restUrl' => rest_url(),
				'sheets'  => SheetModel::getInstance()->getSheets(),
			]
		);
	}
}
