<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector;

use HulkPlugins\ElementorPro\Forms\GSheetConnector\Traits\SingletonTrait;

class I18n {
	use SingletonTrait;

	public function init_hooks() {
		add_action( 'plugins_loaded', [ $this, 'load_text_domain' ] );
	}

	public static function getInstance(): I18n {
		return self::__getInstance();
	}

	/**
	 * Load translation files
	 * @return void
	 */
	public function load_text_domain() {
		load_plugin_textdomain(
			'gsheet-connector-for-elementor-forms',
			false,
			dirname( plugin_basename( __FILE__ ), 2 ) . '/languages/'
		);
	}
}
