<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector\Models;

use HulkPlugins\ElementorPro\Forms\GSheetConnector\Traits\SingletonTrait;
use const HulkPlugins\ElementorPro\Forms\GSheetConnector\PREFIX;

class SheetModel {
	use SingletonTrait;

	private static array $files = [];

	public static function getInstance(): SheetModel {
		return self::__getInstance();
	}

	public function getSheets(): array {
		if ( empty( self::$files ) ) {
			$files = get_option( PREFIX . 'sheet_files' );
			self::$files = is_array( $files ) ? $files : [];
		}
		return self::$files;
	}

	public function updateSheets( array $sheets ): bool {
		$updated = update_option( PREFIX . 'sheet_files', $sheets );
		if ( $updated ) {
			self::$files = [];
		}
		return $updated;
	}

	public function deleteSheets(): bool {
		return delete_option( PREFIX . 'sheet_files' );
	}
}
