<?php

namespace HulkPlugins\ElementorPro\Forms\GSheetConnector\Routes;

use HulkPlugins\ElementorPro\Forms\GSheetConnector\Models\SettingsModel;
use WP_Error;
use WP_HTTP_Response;
use WP_REST_Request;
use WP_REST_Response;
use WP_REST_Server;
use const HulkPlugins\ElementorPro\Forms\GSheetConnector\GROUP;

class SettingsRoute {

	public function __construct() {

		register_rest_route(
			GROUP . '/v1',
			'/save-settings',
			[
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => [ $this, 'save_settings' ],
				'permission_callback' => fn() => current_user_can( 'manage_options' ),
			]
		);
	}

	/**
	 * Save settings callback
	 * @param WP_REST_Request $request
	 *
	 * @return WP_Error|WP_HTTP_Response|WP_REST_Response
	 */
	public function save_settings( WP_REST_Request $request ) {
		$params = $request->get_params();
		$settingsModel = SettingsModel::getInstance();
		$settingsModel->updateSettings( $params );
		return rest_ensure_response( esc_attr__( 'Settings Saved.', 'gsheet-connector-for-elementor-forms' ) );
	}
}
